/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.custom;

import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.UncommonTrapBuilder;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderBuilder;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.log.parser.impl.c4.custom.C4_CustomLineParsersSupport;
import com.azul.log.parser.impl.c4.custom.C4_CustomLogLineParser;
import com.azul.log.parser.spi.ParserFactory;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.parser.support.SingleModifiableFileLogModel;
import com.azul.log.utils.CommonUtils;
import com.azul.tools.profile2xlog.impl.LogTransformer;
import com.azul.zing.GulpZing;
import com.azul.zing.ZingProfileLog;
import com.azul.zing.profilelog.CompilationModelBuilder;
import com.azul.zing.profilelog.KlassLoaderModelBuilder;
import com.azul.zing.profilelog.KlassModelBuilder;
import com.azul.zing.profilelog.MethodModelBuilder;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.UncommonTrapModelBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.concurrent.CancellationException;

public final class C4_CustomRNLogParserFactory
extends ParserFactory<C4_CustomLogLineParser> {
    private UserInteractionHandler ui;

    public C4_CustomRNLogParserFactory() {
        super(ParserFactory.Confidence.HIGH, new String[][]{{"# ZingProfile", "CLASS_LOADH"}});
    }

    @Override
    public C4_CustomLogLineParser createParser(Path path, UserInteractionHandler ui) {
        this.ui = ui;
        return new C4_CustomLogLineParser(new RN_SingleFileLogModel("RN", path));
    }

    private final class RN_SingleFileLogModel
    extends SingleModifiableFileLogModel {
        public RN_SingleFileLogModel(String id, Path file) {
            super(id, file);
            InputStream resourceAsStream = C4_CustomRNLogParserFactory.class.getResourceAsStream("/graphJsons/rn.json");
            if (resourceAsStream == null) {
                throw new RuntimeException("graphJsons/rn.json not found in GCLogAnalyzer2.jar");
            }
            C4_CustomLineParsersSupport.createAndRegisterParsersFromString(id, CommonUtils.inputStreamToString(resourceAsStream));
        }

        @Override
        protected Path modifyFile(Path file) {
            Path transformedRNFile;
            Path path = transformedRNFile = Files.isWritable(file.getParent()) ? Paths.get(file.toAbsolutePath().toString() + ".xlog", new String[0]) : Paths.get(System.getProperty("java.io.tmpdir"), file.getFileName() + ".xlog");
            if (Files.exists(transformedRNFile, new LinkOption[0])) {
                UserInteractionHandler.Response response = C4_CustomRNLogParserFactory.this.ui.confirm("Pre-processed RN log file already exists", "File " + transformedRNFile.getFileName() + " already exists. Do you want to open it ?");
                switch (response) {
                    case YES: {
                        return transformedRNFile;
                    }
                    case CANCEL: {
                        throw new CancellationException();
                    }
                }
            }
            ZingProfileLog zingProfileLog = GulpZing.gulpProfile(file.toFile());
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter((Writer)new FileWriter(transformedRNFile.toFile()), true);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Writing to file '%s' failed", transformedRNFile.getFileName()));
            }
            HashMap<KlassLoaderId, KlassLoaderBuilder> loaderById = new HashMap<KlassLoaderId, KlassLoaderBuilder>();
            HashMap<PersistentKlassId, KlassBuilder> klassById = new HashMap<PersistentKlassId, KlassBuilder>();
            HashMap<CompilationId, CompilationBuilder> compilationById = new HashMap<CompilationId, CompilationBuilder>();
            HashMap<PersistentMethodId, MethodBuilder> methodById = new HashMap<PersistentMethodId, MethodBuilder>();
            HashMap<UncommonTrapId, UncommonTrapBuilder> trapById = new HashMap<UncommonTrapId, UncommonTrapBuilder>();
            zingProfileLog.process(ProfileLogProcessor.compositeOf(new KlassLoaderModelBuilder(loaderById), new KlassModelBuilder(klassById), new CompilationModelBuilder(compilationById), new MethodModelBuilder(methodById), new UncommonTrapModelBuilder(trapById)));
            LogTransformer transformer = new LogTransformer(loaderById, klassById, compilationById, methodById, trapById);
            transformer.process(zingProfileLog, (vmTime, line) -> String.format("%.3f: [%s]", (double)vmTime.toMilliseconds() / 1000.0, line), printWriter);
            printWriter.close();
            return transformedRNFile;
        }
    }
}

