/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.custom;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.impl.c4.C4_LogLineParserProvider;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.custom.C4_CustomLineParserSecurityContext;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.impl.support.CustomParsersCompiler;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.utils.CommonUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mjson.Json;

public final class C4_CustomLineParsersSupport {
    static final String CUSTOM_PACKAGE = C4_CustomLineParsersSupport.class.getPackage().getName() + "_json";
    private static final Map<String, List<Json>> fields = new HashMap<String, List<Json>>();
    private static final Map<String, List<Json>> filters = new HashMap<String, List<Json>>();
    private static CustomParsersCompiler compiler;
    private static Map<String, Json> customJsons;

    private C4_CustomLineParsersSupport() {
    }

    private static void init() {
        C4_LogParser.dummyInit();
        compiler = CustomParsersCompiler.create();
        if (compiler == null) {
            return;
        }
        C4_CustomLineParserSecurityContext.init();
        compiler.reset();
    }

    public static void setDefaultCustomJsonUri(URI uri) {
        String modelID = "C4";
        if (uri == null) {
            return;
        }
        try {
            C4_CustomLineParsersSupport.createAndRegisterParsersFromJson("C4", uri);
        }
        catch (IOException ex) {
            Logger.getLogger(C4_CustomLineParsersSupport.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    private static void registerParsersFromJson(String modelID, Json json) {
        if (json == null) {
            return;
        }
        customJsons.put(modelID, json);
        Json newRecords = json.asJsonMap().get("records");
        C4_LogLineParserProvider.registerParsers(C4_CustomLineParsersSupport.createParsers(newRecords), null);
    }

    public static void createAndRegisterParsersFromString(String modelID, String jsonString) {
        Json json = Json.read(jsonString);
        C4_CustomLineParsersSupport.registerParsersFromJson(modelID, json);
    }

    public static void createAndRegisterParsersFromJson(String modelID, URI jsonUri) throws IOException {
        Json json = CommonUtils.readJSON(jsonUri);
        C4_CustomLineParsersSupport.registerParsersFromJson(modelID, json);
    }

    public static Json getCustomJson(String modelID) {
        return customJsons.containsKey(modelID) ? customJsons.get(modelID).dup() : null;
    }

    public static <T> Class<? extends T> getClass(String className) throws ClassNotFoundException {
        return compiler == null ? null : compiler.loadClass(CUSTOM_PACKAGE + "." + className);
    }

    private static Collection<? extends C4_LogLineParser> createParsers(Json records) {
        if (records == null || !records.isArray()) {
            return Collections.emptyList();
        }
        if (compiler == null) {
            return Collections.emptyList();
        }
        fields.clear();
        filters.clear();
        return records.asJsonList().stream().map(C4_CustomLineParsersSupport::generateAndLoadParser).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static C4_LogLineParser generateAndLoadParser(Json recordNode) {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> recordMap = recordNode.asMap();
        String[] recordClassNames = C4_CustomLineParsersSupport.getRecordClassNames(recordMap);
        String recordClassName = recordClassNames[0].trim();
        Json fieldsNode = recordNode.asJsonMap().get("fields");
        fields.put(recordClassName, fieldsNode == null ? Collections.emptyList() : fieldsNode.asJsonList());
        Json filtersNode = recordNode.asJsonMap().get("filters");
        filters.put(recordClassName, filtersNode == null ? Collections.emptyList() : filtersNode.asJsonList());
        String marker = (String)recordNode.asMap().get("marker");
        sb.append("package ").append(CUSTOM_PACKAGE).append(";");
        Stream.of(LogUnits.class, C4_SingleHeaderDataParser.class, C4_GCLogRecordField.class, C4_LogDataRecord.class, C4_LogRecord.class).forEach(c -> sb.append("import ").append(c.getCanonicalName()).append(";"));
        sb.append("@").append(C4_LogDataRecord.class.getSimpleName()).append("(header_marker = \"").append(marker).append("H\", data_marker = \"").append(marker).append("\")").append("public final class ").append(recordClassName).append(" extends ").append(C4_LogRecord.class.getSimpleName()).append(" {");
        StringBuilder tmp_buffer = new StringBuilder();
        HashMap fields_map = new HashMap();
        HashMap filters_map = new HashMap();
        ArrayList fields_ordered = new ArrayList();
        ArrayList filters_ordered = new ArrayList();
        for (int i = recordClassNames.length - 1; i >= 0; --i) {
            String rn = recordClassNames[i].trim();
            fields.get(rn).forEach(fieldNode -> {
                Map<String, Object> fieldMap = fieldNode.asMap();
                tmp_buffer.setLength(0);
                String fld_name = String.valueOf(fieldMap.get("name"));
                tmp_buffer.append("@").append(C4_GCLogRecordField.class.getSimpleName()).append("(header = \"").append(fieldMap.get("header")).append("\"").append(", defaultUnits = ").append(LogUnits.class.getSimpleName()).append(".").append(LogUnits.safeValueOf(fieldMap.get("units")).name()).append(") public ").append(fieldMap.get("type")).append(" ").append(fld_name).append(";");
                fields_map.put(fld_name, tmp_buffer.toString());
                if (!fields_ordered.contains(fld_name)) {
                    fields_ordered.add(fld_name);
                }
            });
            filters.get(rn).forEach(filterNode -> {
                Map<String, Object> filterMap = filterNode.asMap();
                tmp_buffer.setLength(0);
                String filter_name = String.valueOf(filterMap.get("name"));
                tmp_buffer.append("public boolean ").append(filter_name).append("() { return ").append(filterMap.get("expression")).append(";}");
                filters_map.put(filter_name, tmp_buffer.toString());
                if (!filters_ordered.contains(filter_name)) {
                    filters_ordered.add(filter_name);
                }
            });
        }
        fields_ordered.forEach(f -> sb.append((String)fields_map.get(f)));
        filters_ordered.forEach(f -> sb.append((String)filters_map.get(f)));
        sb.append("public static final class Parser extends ").append(C4_SingleHeaderDataParser.class.getSimpleName()).append("<").append(recordClassName).append("> { public Parser() { super(").append(recordClassName).append(".class); }}}");
        String fullName = CUSTOM_PACKAGE + "." + recordClassName;
        try {
            compiler.compile(fullName, sb.toString());
            compiler.loadClass(fullName);
            return (C4_LogLineParser)compiler.loadClass(fullName + "$Parser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.getLogger(C4_CustomLineParsersSupport.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String[] getRecordClassNames(Map<String, Object> recordMap) {
        String[] recordClassNames = ((String)recordMap.get("class")).split(":");
        for (int i = 0; i < recordClassNames.length; ++i) {
            recordClassNames[i] = TextUtils.toValidJavaIdentifier("c_", recordClassNames[i]);
        }
        return recordClassNames;
    }

    static {
        customJsons = new HashMap<String, Json>();
        C4_CustomLineParsersSupport.init();
    }
}

