/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.spi.LogSummary;
import com.azul.log.parser.impl.c4.records.CompstatsRecord;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.ProfChunkInfoRecord;
import com.azul.log.parser.impl.c4.records.ProfInfoRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class C4_Summary
implements LogSummary {
    public long codeCacheUseMax = -1L;
    public long codeCacheAllocatedMax = -1L;
    public long javaHeapUseMax = -1L;
    public long monitorCacheUseMax = -1L;
    public long monitorCacheAllocatedMax = -1L;
    public int compTier1Threads = -1;
    public int compTier2Threads = -1;
    public int newGCThreads = -1;
    public int oldGCThreads = -1;
    public ProfInfoRecord profInfo = null;
    public ProfChunkInfoRecord firstProfChunkInfoINRecord = null;
    public ProfChunkInfoRecord lastProfChunkInfoINRecord = null;
    private final Map<Class<? extends LogRecord>, Consumer<LogRecord>> map = new HashMap<Class<? extends LogRecord>, Consumer<LogRecord>>();

    public boolean processRecord(LogRecord logRecord) {
        this.map.computeIfAbsent(logRecord.getClass(), logRecordClass -> {
            if (logRecordClass.isAssignableFrom(GCRecord.class)) {
                return record -> this.processGCRecord((LogRecord)record);
            }
            if (logRecordClass.isAssignableFrom(CompstatsRecord.class)) {
                return record -> this.processCompstatsRecord((LogRecord)record);
            }
            if (logRecordClass.isAssignableFrom(ProfInfoRecord.class)) {
                return record -> this.processProfInfoRecord((LogRecord)record);
            }
            if (logRecordClass.isAssignableFrom(ProfChunkInfoRecord.class)) {
                return record -> this.processProfChunkInfoRecord((LogRecord)record);
            }
            return record -> {};
        }).accept(logRecord);
        return true;
    }

    private void processGCRecord(LogRecord record) {
        GCRecord gcRecord = (GCRecord)record;
        this.codeCacheUseMax = Math.max(this.codeCacheUseMax, (long)gcRecord.code_cache_used_mb);
        this.codeCacheAllocatedMax = Math.max(this.codeCacheAllocatedMax, (long)gcRecord.code_cache_cap_mb);
        this.monitorCacheAllocatedMax = this.monitorCacheUseMax = Math.max(this.monitorCacheUseMax, (long)gcRecord.monitor_cache_used_mb);
        this.javaHeapUseMax = Math.max(this.javaHeapUseMax, (long)gcRecord.peak);
        if (this.newGCThreads < 0 && gcRecord.isNew()) {
            this.newGCThreads = gcRecord.thread_count;
        }
        if (this.oldGCThreads < 0 && gcRecord.isOld()) {
            this.oldGCThreads = gcRecord.thread_count;
        }
    }

    private void processCompstatsRecord(LogRecord record) {
        CompstatsRecord compstatsRecord = (CompstatsRecord)record;
        if (compstatsRecord.threads_total > 0) {
            if ("1".equals(compstatsRecord.tier)) {
                this.compTier1Threads = Math.max(this.compTier1Threads, compstatsRecord.threads_total);
            } else {
                this.compTier2Threads = Math.max(this.compTier2Threads, compstatsRecord.threads_total);
            }
        }
    }

    private void processProfInfoRecord(LogRecord record) {
        ProfInfoRecord profInfoRecord = (ProfInfoRecord)record;
        if (this.profInfo == null || this.profInfo.generation < profInfoRecord.generation) {
            this.profInfo = profInfoRecord;
        }
    }

    private void processProfChunkInfoRecord(LogRecord record) {
        ProfChunkInfoRecord profChunkInfoRecord = (ProfChunkInfoRecord)record;
        if (profChunkInfoRecord.isOutgoing()) {
            return;
        }
        if (this.firstProfChunkInfoINRecord == null) {
            this.firstProfChunkInfoINRecord = profChunkInfoRecord;
        }
        this.lastProfChunkInfoINRecord = profChunkInfoRecord;
    }
}

