/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DataLineParser;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class C4_SingleHeaderDataParser<R extends C4_LogRecord>
extends C4_DataLineParser<R> {
    public C4_SingleHeaderDataParser(Class<R> klass) {
        super(klass);
    }

    @Override
    public Collection<String> getPrefixes() {
        return Arrays.asList(this.header_marker, this.data_marker);
    }

    @Override
    protected final Map<String, Field> init_fields() {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : this.klass.getFields()) {
            if (!field.isAnnotationPresent(C4_GCLogRecordField.class)) continue;
            map.put(field.getAnnotation(C4_GCLogRecordField.class).header(), field);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected boolean parseHeaderImpl(String header) throws ParserException {
        String[] fields = header.split("[\t ]+");
        ArrayList<Field> header_arr = new ArrayList<Field>();
        for (String field : fields) {
            header_arr.add(this.hdr_to_fld.getOrDefault(field, null));
        }
        this.defineFields(header_arr);
        return true;
    }

    protected String getFallbackHeader() {
        return null;
    }

    protected boolean applyFallbackHeader() throws ParserException {
        C4_LogParser.DataLine header;
        String fallbackHeader = this.getFallbackHeader();
        if (Objects.nonNull(fallbackHeader) && Objects.nonNull(header = C4_LogParser.DataLine.parse(fallbackHeader))) {
            return this.parseHeaderImpl(header.data);
        }
        return false;
    }
}

