/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.impl.c4.C4_LogModel;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.utils.C4_LogFilesSupport;
import com.azul.log.parser.spi.ParserFactory;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public final class C4_ParserFactories {
    private C4_ParserFactories() {
    }

    public static final class C4_ParserFactory
    extends ParserFactory<C4_LogParser> {
        public C4_ParserFactory() {
            super(ParserFactory.Confidence.HIGH, {"GenPauseless"}, {"[GCHH "}, {"Zing"});
        }

        @Override
        public C4_LogParser createParser(Path path, UserInteractionHandler ui) {
            List<C4_LogFilesSupport.C4_GCLogFile> logFiles = C4_LogFilesSupport.findGCLogFiles(path);
            int numberOfFiles = logFiles.size();
            if (numberOfFiles == 0) {
                return null;
            }
            if (numberOfFiles > 1) {
                UserInteractionHandler.Response response = ui.confirm("Multiple gc log files found for the same VM run", "File " + path.getFileName() + " is one from a series of rotated gc log files for the same VM run.\nDo you want to open all " + numberOfFiles + " logs found next to this one? ");
                switch (response) {
                    case NO: {
                        logFiles = logFiles.stream().filter(f -> f.getPath().equals(path)).collect(Collectors.toList());
                        break;
                    }
                    case CANCEL: {
                        return null;
                    }
                }
            }
            return C4_LogParser.create(new C4_LogModel(logFiles));
        }
    }
}

