/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LogLineParserProvider;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.spi.LogParserImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class C4_ParseReplaySupport {
    private static final Map<String, List<LogLineWithLineNumber>> map = new ConcurrentHashMap<String, List<LogLineWithLineNumber>>();
    private static LogParserImpl<?> parser;

    static void push(int lineNumber, LogLineWithTime logLineWithTime, String data_marker) {
        map.computeIfAbsent(data_marker, m -> new LinkedList()).add(new LogLineWithLineNumber(lineNumber, logLineWithTime));
    }

    static void replay(String data_marker) throws ParserException {
        List<LogLineWithLineNumber> list = map.remove(data_marker);
        if (list != null) {
            for (LogLineWithLineNumber line : list) {
                parser.processLine(line.lineNumber, line.line);
            }
        }
    }

    static void init(LogParserImpl<?> parser) {
        C4_ParseReplaySupport.parser = parser;
        map.clear();
    }

    private static boolean replayWithKnownHeaders(String data_marker) throws ParserException {
        boolean replaySuccess = false;
        for (C4_LogLineParser c4_logLineParser : C4_LogLineParserProvider.getParsers(data_marker)) {
            if (!C4_SingleHeaderDataParser.class.isAssignableFrom(c4_logLineParser.getClass())) continue;
            replaySuccess = ((C4_SingleHeaderDataParser)c4_logLineParser).applyFallbackHeader();
        }
        if (replaySuccess) {
            map.remove(data_marker);
        }
        return replaySuccess;
    }

    public static void teardown() {
        for (String data_marker : map.keySet()) {
            try {
                if (C4_ParseReplaySupport.replayWithKnownHeaders(data_marker)) {
                    continue;
                }
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            Logger.getLogger(C4_ParseReplaySupport.class.getName()).log(Level.WARNING, "Unable to parse {0} {1} data lines - no header found", new Object[]{map.get(data_marker).size(), data_marker});
        }
        map.clear();
    }

    private static class LogLineWithLineNumber {
        private final int lineNumber;
        private final LogLineWithTime line;

        private LogLineWithLineNumber(int lineNumber, LogLineWithTime line) {
            this.lineNumber = lineNumber;
            this.line = line;
        }
    }
}

