/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LegacyGCLogLineFormat;
import com.azul.log.parser.impl.c4.C4_LogLineParserProvider;
import com.azul.log.parser.impl.c4.C4_LogModel;
import com.azul.log.parser.impl.c4.C4_LogRecordFieldsProvider;
import com.azul.log.parser.impl.c4.C4_ParseReplaySupport;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.C4_Summary;
import com.azul.log.parser.impl.c4.C4_UnifiedGCLogLineFormat;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.spi.C4_LogLineFormat;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.spi.LogParserImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class C4_LogParser
extends LogParserImpl<C4_ParserState> {
    private static C4_LogLineFormat lineFormat;
    private static Function<CharSequence, LogLineWithTime> parseFunction;
    private final C4_LogHeader header = new C4_LogHeader();
    private final C4_Summary summary = new C4_Summary();

    private C4_LogParser(C4_LogModel model) {
        super(model, new C4_ParserState());
        this.ic.add(this.header);
        this.ic.add(this.summary);
        this.ic.add(new C4_LogRecordFieldsProvider());
        C4_LogLineParserProvider.init(this.getLookup());
    }

    static C4_LogParser create(C4_LogModel model) {
        C4_LogParser parser = new C4_LogParser(model);
        C4_ParseReplaySupport.init(parser);
        lineFormat = null;
        parseFunction = C4_LogParser::parseRawStringGuessFormat;
        return parser;
    }

    public static void dummyInit() {
        C4_LogModel dummyModel = new C4_LogModel(Collections.emptyList());
        C4_LogParser dummyParser = new C4_LogParser(dummyModel);
    }

    public static LogLineWithTime parseRawString(CharSequence line) {
        return parseFunction.apply(line);
    }

    public static LogLineWithTime parseRawStringKnownFormat(CharSequence line) {
        return lineFormat.parse(line);
    }

    public static LogLineWithTime parseRawStringGuessFormat(CharSequence line) {
        if (line.length() == 0) {
            return null;
        }
        if (lineFormat == null && (lineFormat = C4_UnifiedGCLogLineFormat.guess(line)) == null && (lineFormat = C4_LegacyGCLogLineFormat.guess(line)) == null) {
            return null;
        }
        LogLineWithTime res = lineFormat.parse(line);
        if (res == null) {
            lineFormat = null;
        } else {
            parseFunction = C4_LogParser::parseRawStringKnownFormat;
        }
        return res;
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) {
        LogLineWithTime logLineWithTime = C4_LogParser.parseRawString(line);
        if (logLineWithTime == null) {
            return new LogLineWithTime(line);
        }
        AbsoluteTimestamp abs = logLineWithTime.getAbsoluteTimestamp();
        RelativeTimestamp rel = logLineWithTime.getRelativeTimestamp();
        if (abs == null && rel == null) {
            return logLineWithTime;
        }
        if (this.header.jvm_start_time == null && abs != null) {
            AbsoluteTimestamp absoluteTimestamp = this.header.jvm_start_time = rel == null ? abs : abs.shift(-rel.getInUnits(LogUnits.NANOSECONDS), LogUnits.NANOSECONDS);
        }
        if (this.header.jvm_start_time != null) {
            if (abs == null) {
                logLineWithTime.setAbsoluteTimestamp(this.header.jvm_start_time.shift(rel.getInUnits(LogUnits.NANOSECONDS), LogUnits.NANOSECONDS));
            }
            if (rel == null) {
                logLineWithTime.setRelativeTimestamp(RelativeTimestamp.of(AbsoluteTimestamp.delta(abs, this.header.jvm_start_time, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS));
            }
        }
        return logLineWithTime;
    }

    @Override
    protected List<? extends LogRecord> getLogRecordsImpl(String data) throws ParserException {
        DataLine dataLine = DataLine.parse(data);
        List<LogRecord> records = null;
        if (dataLine != null && (records = this.parseLine(dataLine)) != null) {
            records.forEach(this.summary::processRecord);
        }
        return records;
    }

    private List<LogRecord> parseLine(DataLine dataLine) throws ParserException {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        Set<C4_LogLineParser> parsers = C4_LogLineParserProvider.getParsers(dataLine);
        if (parsers != null) {
            boolean processed = false;
            for (C4_LogLineParser parser : parsers) {
                C4_LogLineParser.DataLineParseResult result = parser.parseDataLine((C4_ParserState)this.state, dataLine);
                if (result == null) continue;
                processed = true;
                if (result == C4_LogLineParser.DataLineParseResult.DUMMY_RESULT) continue;
                records.add(result.record);
            }
            if (processed) {
                return records;
            }
            C4_ParseReplaySupport.push(((C4_ParserState)this.state).getCurrentLineNumber(), ((C4_ParserState)this.state).getCurrentLine(), dataLine.prefix);
        }
        return null;
    }

    @Override
    public void teardown() {
        C4_ParseReplaySupport.teardown();
        ((C4_LogModel)this.model).setLogUID(this.calculateLogUID());
    }

    private String calculateLogUID() {
        String hostName = this.header.machine_name;
        Integer pid = this.header.current_process_id;
        AbsoluteTimestamp jvm_start_time = this.header.jvm_start_time;
        String ts = jvm_start_time == null ? "null" : Long.toString(jvm_start_time.toEpochTime());
        return Integer.toHexString((ts + pid + hostName).hashCode());
    }

    public static final class DataLine {
        public final String prefix;
        public final String data;

        public DataLine(String prefix, String data) {
            this.prefix = prefix;
            this.data = data;
        }

        public static DataLine parse(String dataLine) {
            if (!dataLine.startsWith("[") || !dataLine.endsWith("]")) {
                return null;
            }
            int start_idx = dataLine.indexOf(32);
            int end_idx = dataLine.length() - 2;
            while (dataLine.charAt(end_idx) == ' ') {
                --end_idx;
            }
            return start_idx > 0 ? new DataLine(dataLine.substring(1, start_idx), dataLine.substring(start_idx + 1, end_idx + 1)) : null;
        }
    }
}

