/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;

public final class C4_LogLineParserProvider {
    private static final Map<String, Set<C4_LogLineParser>> prefix_to_parser = new HashMap<String, Set<C4_LogLineParser>>();

    static void init(Lookup lookup) {
        prefix_to_parser.clear();
        Collection<C4_LogLineParser> parsers = Lookup.getDefault().lookupAll(C4_LogLineParser.class);
        C4_LogLineParserProvider.registerParsers(parsers, lookup);
    }

    public static void registerParsers(Collection<? extends C4_LogLineParser> parsers, Lookup lookup) {
        for (C4_LogLineParser c4_LogLineParser : parsers) {
            boolean initialize = true;
            Collection<String> prefixes = c4_LogLineParser.getPrefixes();
            for (String prefix : prefixes) {
                Set set = prefix_to_parser.computeIfAbsent(prefix, p -> new HashSet());
                if (set.contains(c4_LogLineParser)) {
                    initialize = false;
                    break;
                }
                set.add(c4_LogLineParser);
            }
            if (!initialize) continue;
            c4_LogLineParser.init(lookup);
        }
    }

    private C4_LogLineParserProvider() {
    }

    public static Set<C4_LogLineParser> getParsers(C4_LogParser.DataLine line) {
        return C4_LogLineParserProvider.getParsers(line.prefix);
    }

    public static Set<C4_LogLineParser> getParsers(String prefix) {
        return prefix_to_parser.get(prefix);
    }
}

