/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DataLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class C4_DoubleHeaderDataParser<R extends C4_LogRecord>
extends C4_DataLineParser<R> {
    private String first_header_line;
    private int line = 0;

    public C4_DoubleHeaderDataParser(Class<R> klass) {
        super(klass);
    }

    @Override
    public final Collection<String> getPrefixes() {
        return Arrays.asList(this.header_marker, this.data_marker);
    }

    @Override
    protected boolean parseHeaderImpl(String header) throws ParserException {
        header = header.replaceAll("\\s*]\\s*$", "");
        if (this.line == 0) {
            this.first_header_line = header;
        } else {
            String[] fixup = this.getFirstLineFixupMatrix();
            if (fixup != null) {
                for (int i = 0; i < fixup.length; i += 3) {
                    if (!fixup[i].equals(this.first_header_line) || !fixup[i + 1].equals(header)) continue;
                    this.first_header_line = fixup[i + 2];
                    break;
                }
            }
            ArrayList<Integer> groups_start_pos = new ArrayList<Integer>();
            ArrayList<String> groups = new ArrayList<String>();
            ArrayList<Field> header_arr = new ArrayList<Field>();
            int group_start_pos = 0;
            Pattern p = Pattern.compile("[ :]+[ :]+");
            Matcher m = p.matcher(this.first_header_line);
            groups_start_pos.add(group_start_pos);
            while (m.find()) {
                groups.add(this.first_header_line.substring(group_start_pos, m.start()));
                group_start_pos = m.end();
                groups_start_pos.add(group_start_pos);
            }
            groups.add(this.first_header_line.substring(group_start_pos));
            groups_start_pos.add(header.length());
            StringBuilder sb = new StringBuilder();
            int group = 0;
            p = Pattern.compile("[^ ]+");
            m = p.matcher(header);
            sb.append((String)groups.get(group));
            if (sb.length() > 0) {
                sb.append('#');
            }
            int group_len = sb.length();
            while (m.find()) {
                if (m.group().equals(":")) {
                    header_arr.add(null);
                    continue;
                }
                if (m.start() >= (Integer)groups_start_pos.get(group + 1)) {
                    sb.setLength(0);
                    sb.append((String)groups.get(++group)).append('#');
                    group_len = sb.length();
                }
                sb.setLength(group_len);
                sb.append(header, m.start(), m.end());
                String key = sb.toString();
                if (this.hdr_to_fld.containsKey(key)) {
                    header_arr.add((Field)this.hdr_to_fld.get(key));
                    continue;
                }
                System.err.println("Warning: field " + key + " is unknown!");
                header_arr.add(null);
            }
            this.defineFields(header_arr);
        }
        this.line = (this.line + 1) % 2;
        return true;
    }
}

