/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl;

import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.spi.annotations.GCLogLineData;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.ParserState;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PrefixedLinesParser<T extends ParserState>
extends LogParserImpl<T> {
    private final PrefixedLineDefinition[] definitions;
    private final int definitionsSize;
    private int prefixIdx;

    protected PrefixedLinesParser(LogModel model, T state, PrefixedLineDefinition[] definitions) {
        super(model, state);
        this.definitions = definitions;
        this.definitionsSize = definitions.length;
    }

    @Override
    public final List<LogRecord> getLogRecordsImpl(String data) {
        if (data.length() == 0 || this.definitions.length == 0) {
            return null;
        }
        int prefix_idx = this.prefixIdx;
        do {
            if (TextUtils.startsWith(data, this.definitions[this.prefixIdx].prefix)) {
                for (LogLineParser<LogRecord, ParserState> lineParser : this.definitions[this.prefixIdx].parsers) {
                    try {
                        List<LogRecord> records;
                        if (data.endsWith("]")) {
                            data = data.substring(0, data.length() - 1);
                        }
                        if ((records = lineParser.parseDataChunk(data)) != null) {
                            records.forEach(record -> lineParser.postProcessRecord((LogRecord)record, this.state));
                            this.prefixIdx = (this.prefixIdx + 1) % this.definitionsSize;
                            return records;
                        }
                    }
                    catch (ParserException parserException) {
                        // empty catch block
                    }
                }
            }
            this.prefixIdx = (this.prefixIdx + 1) % this.definitionsSize;
        } while (this.prefixIdx != prefix_idx);
        return null;
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) {
        CharSequence l = TextUtils.trim(line);
        if (l.length() == 0 || !Character.isDigit(l.charAt(0)) && l.charAt(0) != '[') {
            return new LogLineWithTime(line);
        }
        CharSequence abs_time = null;
        CharSequence rel_time = null;
        int data_start_idx = -1;
        int space_idx = 0;
        for (int i = 0; i < l.length(); ++i) {
            char c = l.charAt(i);
            if (c == '[') {
                int end = l.length();
                while (--end > i && (Character.isWhitespace(c = l.charAt(end)) || c == ']')) {
                }
                data_start_idx = i + 1;
                break;
            }
            if (c == '-') {
                if (rel_time != null || (space_idx = TextUtils.indexOf(l, ": ", i)) == -1) break;
                abs_time = l.subSequence(0, space_idx);
                i = space_idx + 2;
                if (Character.isDigit(l.charAt(i))) {
                    space_idx = TextUtils.indexOf(l, ": ", i);
                    if (space_idx == -1) break;
                    rel_time = l.subSequence(i, space_idx);
                    i = space_idx + 1;
                    continue;
                }
                --i;
                continue;
            }
            if (c == '.') {
                int s = space_idx;
                space_idx = TextUtils.indexOf(l, ": ", i);
                if (space_idx == -1) break;
                rel_time = l.subSequence(s, space_idx);
                i = space_idx + 1;
            }
            if (rel_time == null) continue;
            while (Character.isWhitespace(l.charAt(i))) {
                ++i;
            }
            if (l.charAt(i) == '[') {
                --i;
                continue;
            }
            data_start_idx = i;
            break;
        }
        return new LogLineWithTime(abs_time, rel_time, data_start_idx, line);
    }

    protected boolean processRawLine(CharSequence line) {
        return true;
    }

    protected static class PrefixedLineDefinition {
        protected final String prefix;
        protected final LogLineParser<LogRecord, ParserState>[] parsers;

        public PrefixedLineDefinition(String prefix, Class ... lineKlassList) {
            ArrayList<LogLineParser> ps = new ArrayList<LogLineParser>();
            for (Class clazz : lineKlassList) {
                Class<? extends LogLineParser> parserClass = null;
                for (Class c = clazz; c != null; c = c.getSuperclass()) {
                    GCLogLineData annotation = c.getAnnotation(GCLogLineData.class);
                    if (annotation == null) continue;
                    parserClass = annotation.parserClass();
                    break;
                }
                if (parserClass == null) {
                    throw new InternalError("Cannot find GCLogLineData annotation for " + clazz);
                }
                try {
                    Constructor<? extends LogLineParser> constructor = parserClass.getConstructor(Class.class);
                    LogLineParser p = constructor.newInstance(clazz);
                    ps.add(p);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    Logger.getLogger(PrefixedLinesParser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.prefix = prefix;
            this.parsers = ps.toArray(new LogLineParser[0]);
        }
    }
}

