/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.api.LogReader;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.LogStreamHandler;
import com.azul.log.parser.spi.ParserExceptionHandler;
import com.azul.log.parser.spi.ParserFactory;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.utils.ProgressModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class LogParser {
    private final List<ParserExceptionHandler> exceptionHandlers = new ArrayList<ParserExceptionHandler>();
    private final List<LogStreamHandler> streamHandlers = new ArrayList<LogStreamHandler>();
    private final LogParserImpl<?> parser;
    private BiFunction<Integer, String, Boolean> lineProcessor;
    private long logFileDigest;

    private LogParser(LogParserImpl<?> parser) {
        this.parser = parser;
    }

    public static LogParser getParserFor(Path path, UserInteractionHandler ui) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(path + " not found");
        }
        if (!Files.isReadable(path)) {
            throw new IOException(path + " is not readable");
        }
        if (!path.toFile().isFile()) {
            throw new IOException(path + " is not a regular file");
        }
        List<ParserFactory<Object>> factories = ParserFactory.getParserFactoriesFor(path);
        if (factories.size() != 1 && (factories = factories.stream().filter(f -> f.getConfidence() == ParserFactory.Confidence.HIGH).collect(Collectors.toList())).size() != 1) {
            return null;
        }
        Object parser = factories.get(0).createParser(path, ui);
        return parser == null ? null : new LogParser((LogParserImpl<?>)parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogFile parse(ProgressModel progress) throws IOException {
        this.lineProcessor = this.streamHandlers.isEmpty() ? this::parseLine : this::processLine;
        try (LogReader reader = this.parser.createReader(progress);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (this.lineProcessor.apply(reader.currentLineNumber(), line).booleanValue()) continue;
                throw new ParserException("File parse failed");
            }
            this.logFileDigest = reader.getDigest();
        }
        finally {
            this.parser.teardown();
        }
        return new LogFile(this.parser.getLookup(), this.logFileDigest);
    }

    public LogModel getModel() {
        return this.parser.getModel();
    }

    public void addStreamHandler(LogStreamHandler handler) {
        this.streamHandlers.add(handler);
    }

    public void addParserExceptionHandler(ParserExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    private boolean processLine(Integer lineNumber, String line) {
        Iterator<LogStreamHandler> it = this.streamHandlers.iterator();
        while (it.hasNext()) {
            try {
                if (it.next().processLine(lineNumber, line)) continue;
                it.remove();
            }
            catch (Exception ex) {
                return this.processException(lineNumber, line, ex);
            }
        }
        if (this.streamHandlers.isEmpty()) {
            this.lineProcessor = this::parseLine;
        }
        return this.parseLine(lineNumber, line);
    }

    private boolean parseLine(Integer lineNumber, String line) {
        try {
            this.parser.processLine((int)lineNumber, TextUtils.trim(line));
            return true;
        }
        catch (ParserException ex) {
            return this.processException(lineNumber, line, ex);
        }
    }

    private boolean processException(Integer lineNumber, String line, Exception ex) {
        ParserException pex = new ParserException((int)lineNumber, line, ex);
        return this.exceptionHandlers.stream().map(h -> h.handleException(pex)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }
}

