/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.utils.TextUtils;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogLineWithTime {
    private final String data;
    private final int dataStartIndex;
    private AbsoluteTimestamp absoluteTimestamp;
    private RelativeTimestamp relativeTimestamp;

    public LogLineWithTime(AbsoluteTimestamp absoluteTimestamp, RelativeTimestamp relativeTimestamp, int prefixLength, CharSequence rawLine) {
        this.absoluteTimestamp = absoluteTimestamp;
        this.relativeTimestamp = relativeTimestamp;
        int e = rawLine.length();
        int s = Math.min(prefixLength, e);
        while (s < e && Character.isWhitespace(rawLine.charAt(s))) {
            ++s;
            ++prefixLength;
        }
        this.dataStartIndex = prefixLength;
        this.data = TextUtils.trimRight(prefixLength >= 0 ? rawLine.subSequence(s, e) : rawLine).toString();
    }

    public LogLineWithTime(CharSequence absTime, CharSequence relTime, int prefixLength, CharSequence rawLine) {
        this(LogLineWithTime.parseAbsoluteTimestamp(absTime), LogLineWithTime.parseRelativeTimestamp(relTime), prefixLength, rawLine);
    }

    public LogLineWithTime(CharSequence rawLine) {
        this.absoluteTimestamp = null;
        this.relativeTimestamp = null;
        this.dataStartIndex = 0;
        this.data = TextUtils.trimRight(rawLine).toString();
    }

    private static AbsoluteTimestamp parseAbsoluteTimestamp(CharSequence absTime) {
        if (absTime != null) {
            try {
                return AbsoluteTimestamp.parse(absTime);
            }
            catch (ParseException ex) {
                Logger.getLogger(LogLineWithTime.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private static RelativeTimestamp parseRelativeTimestamp(CharSequence relTime) {
        if (relTime != null) {
            try {
                return RelativeTimestamp.parse(relTime, TimeUnit.SECONDS);
            }
            catch (ParseException ex) {
                Logger.getLogger(LogLineWithTime.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public final String getData() {
        return this.data;
    }

    public final AbsoluteTimestamp getAbsoluteTimestamp() {
        return this.absoluteTimestamp;
    }

    public final void setAbsoluteTimestamp(AbsoluteTimestamp absoluteTimestamp) {
        this.absoluteTimestamp = absoluteTimestamp;
    }

    public final RelativeTimestamp getRelativeTimestamp() {
        return this.relativeTimestamp;
    }

    public final void setRelativeTimestamp(RelativeTimestamp relativeTimestamp) {
        this.relativeTimestamp = relativeTimestamp;
    }

    public final int getDataStartIndex() {
        return this.dataStartIndex;
    }

    public String toString() {
        return String.format("[%s] [%s] [%s]", this.absoluteTimestamp, this.relativeTimestamp, this.data);
    }
}

