/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum LogUnits {
    BYTES("Bytes"),
    KILOBYTES("Kilobytes", "Kb"),
    MEGABYTES("Megabytes", "Mb"),
    GIGABYTES("Gigabytes", "Gb"),
    TERABYTES("Terabytes", "Tb"),
    PAGES("Pages"),
    NANOSECONDS("Nanoseconds", "ns."),
    MICROSECONDS("Microseconds", "us."),
    MILLISECONDS("Milliseconds", "ms."),
    SECONDS("Seconds", "sec."),
    MINUTES("Minutes", "min."),
    HOURS("Hours", "hrs."),
    DAYS("Days", "d."),
    CODEBLOBS("Code Blobs"),
    COUNT("Count", ""),
    CORES("Cores"),
    GCCYCLES("GC Cycles", "GC Cycles"),
    KIDS("Number of KlassIDs", "KIDs"),
    METHODS("Methods"),
    PERCENT("Percents", "%"),
    PROCESSES("Processes"),
    RATE_KIDSPS("KlassIDs per Second", "KIDs/sec."),
    RATE_MBPS("Megabytes per Second", "Mb/sec."),
    THREADS("Threads"),
    UNSPECIFIED("");

    private static final Map<TimeUnit, LogUnits> timeToLogUnits;
    private static final Map<LogUnits, TimeUnit> logToTimeUnits;
    private final String displayName;
    private final String abbreviation;

    private LogUnits(String displayName, String abbreviation) {
        this.displayName = displayName;
        this.abbreviation = abbreviation;
    }

    private LogUnits(String displayName) {
        this(displayName, displayName);
    }

    public static LogUnits of(TimeUnit timeUnit) {
        return timeToLogUnits.get((Object)timeUnit);
    }

    public static LogUnits safeValueOf(Object str) throws IllegalArgumentException {
        return str == null || str.toString().isEmpty() ? UNSPECIFIED : Enum.valueOf(LogUnits.class, str.toString().toUpperCase(Locale.US));
    }

    public TimeUnit toTimeUnits() {
        return logToTimeUnits.get((Object)this);
    }

    public double convertTo(double value, LogUnits targetUnits) throws IllegalArgumentException {
        if (UNSPECIFIED.equals((Object)this) || UNSPECIFIED.equals((Object)targetUnits)) {
            return value;
        }
        if (this.equals((Object)targetUnits)) {
            return value;
        }
        switch (this) {
            case GIGABYTES: {
                switch (targetUnits) {
                    case MEGABYTES: {
                        return value * 1024.0;
                    }
                    case KILOBYTES: {
                        return value * 1048576.0;
                    }
                    case BYTES: {
                        return value * 1.073741824E9;
                    }
                }
                break;
            }
            case MEGABYTES: {
                switch (targetUnits) {
                    case KILOBYTES: {
                        return value * 1024.0;
                    }
                    case BYTES: {
                        return value * 1048576.0;
                    }
                }
                break;
            }
            case KILOBYTES: {
                switch (targetUnits) {
                    case MEGABYTES: {
                        return value / 1024.0;
                    }
                    case BYTES: {
                        return value * 1024.0;
                    }
                }
                break;
            }
            case BYTES: {
                switch (targetUnits) {
                    case MEGABYTES: {
                        return value / 1048576.0;
                    }
                    case KILOBYTES: {
                        return value / 1024.0;
                    }
                }
                break;
            }
            case MICROSECONDS: {
                switch (targetUnits) {
                    case NANOSECONDS: {
                        return value * 1000.0;
                    }
                }
                break;
            }
            case MILLISECONDS: {
                switch (targetUnits) {
                    case SECONDS: {
                        return value / 1000.0;
                    }
                    case NANOSECONDS: {
                        return value * 1000000.0;
                    }
                    case MINUTES: {
                        return value / 60000.0;
                    }
                }
                break;
            }
            case NANOSECONDS: {
                switch (targetUnits) {
                    case MICROSECONDS: {
                        return value / 1000.0;
                    }
                    case MILLISECONDS: {
                        return value / 1000000.0;
                    }
                    case SECONDS: {
                        return value / 1.0E9;
                    }
                    case MINUTES: {
                        return value / 6.0E10;
                    }
                }
                break;
            }
            case SECONDS: {
                switch (targetUnits) {
                    case MILLISECONDS: {
                        return value * 1000.0;
                    }
                    case NANOSECONDS: {
                        return value * 1.0E9;
                    }
                }
                break;
            }
            case MINUTES: {
                switch (targetUnits) {
                    case NANOSECONDS: {
                        return value * 6.0E10;
                    }
                }
                break;
            }
            case HOURS: {
                switch (targetUnits) {
                    case NANOSECONDS: {
                        return value * 3.6E12;
                    }
                }
                break;
            }
            case THREADS: {
                switch (targetUnits) {
                    case COUNT: {
                        return value;
                    }
                }
                break;
            }
        }
        throw new IllegalArgumentException("Cannot convert " + this.name() + " to " + targetUnits.name());
    }

    public String toString() {
        return this.abbreviation;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    static {
        timeToLogUnits = new HashMap<TimeUnit, LogUnits>();
        logToTimeUnits = new HashMap<LogUnits, TimeUnit>();
        timeToLogUnits.put(TimeUnit.NANOSECONDS, NANOSECONDS);
        timeToLogUnits.put(TimeUnit.MICROSECONDS, MICROSECONDS);
        timeToLogUnits.put(TimeUnit.MILLISECONDS, MILLISECONDS);
        timeToLogUnits.put(TimeUnit.SECONDS, SECONDS);
        timeToLogUnits.put(TimeUnit.MINUTES, MINUTES);
        timeToLogUnits.put(TimeUnit.HOURS, HOURS);
        timeToLogUnits.put(TimeUnit.DAYS, DAYS);
        logToTimeUnits.put(NANOSECONDS, TimeUnit.NANOSECONDS);
        logToTimeUnits.put(MICROSECONDS, TimeUnit.MICROSECONDS);
        logToTimeUnits.put(MILLISECONDS, TimeUnit.MILLISECONDS);
        logToTimeUnits.put(SECONDS, TimeUnit.SECONDS);
        logToTimeUnits.put(MINUTES, TimeUnit.MINUTES);
        logToTimeUnits.put(HOURS, TimeUnit.HOURS);
        logToTimeUnits.put(DAYS, TimeUnit.DAYS);
    }
}

