/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.PlotSeriesVisibilityModel;
import com.azul.log.gui.model.support.AbstractModel;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public final class PlotSeriesVisibilitySupport {
    private static final Map<Integer, boolean[]> map = new HashMap<Integer, boolean[]>();

    private PlotSeriesVisibilitySupport() {
    }

    public static PlotSeriesVisibilityModel createChartSeriesVisibilityModel(GraphDefinition gd, JFreeChart chart) {
        return new PlotSeriesVisibilityModelImpl(gd, chart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<Integer, boolean[]> map = PlotSeriesVisibilitySupport.map;
        synchronized (map) {
            PlotSeriesVisibilitySupport.map.clear();
        }
    }

    private static class PlotSeriesVisibilityModelImpl
    extends AbstractModel
    implements PlotSeriesVisibilityModel {
        private final List<PlotSeriesVisibilityModel.SeriesInfo> data;
        private final Integer graphID;
        private final JFreeChart chart;

        private PlotSeriesVisibilityModelImpl(GraphDefinition gd, JFreeChart chart) {
            this.graphID = gd.getID();
            this.data = this.initData(gd, chart);
            this.chart = chart;
        }

        @Override
        public List<PlotSeriesVisibilityModel.SeriesInfo> getSeriesInfoData() {
            return this.data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PlotSeriesVisibilityModel.SeriesInfo> initData(GraphDefinition gd, JFreeChart chart) {
            boolean[] data;
            LegendItemCollection legendItems = chart.getPlot().getLegendItems();
            ArrayList<PlotSeriesVisibilityModel.SeriesInfo> info = new ArrayList<PlotSeriesVisibilityModel.SeriesInfo>();
            Map map = map;
            synchronized (map) {
                data = (boolean[])map.get(this.graphID);
                if (data == null) {
                    data = gd.getInitialSeriesVisibilityState();
                    if (data.length != legendItems.getItemCount()) {
                        throw new InternalError("Unexpected difference in sizes");
                    }
                    map.put(this.graphID, data);
                }
            }
            Iterator it = legendItems.iterator();
            XYPlot plot = (XYPlot)chart.getPlot();
            int idx = 0;
            while (it.hasNext()) {
                LegendItem i = (LegendItem)it.next();
                XYItemRenderer r = plot.getRenderer(i.getDatasetIndex());
                info.add(new SeriesInfoImpl(i, r, data[idx++]));
            }
            return info;
        }

        @Override
        public void showAll(boolean show) {
            if (this.data.stream().map(SeriesInfoImpl.class::cast).map(i -> ((SeriesInfoImpl)i).setVisible(show, false)).reduce(false, (st, res) -> st | res).booleanValue()) {
                this.chart.fireChartChanged();
                this.fireChange();
            }
        }

        private final class SeriesInfoImpl
        implements PlotSeriesVisibilityModel.SeriesInfo {
            private final LegendItem item;
            private final XYItemRenderer renderer;

            public SeriesInfoImpl(LegendItem i, XYItemRenderer r, boolean init) {
                this.item = i;
                this.renderer = r;
                this.setVisible(init, false);
            }

            @Override
            public String getLabel() {
                return this.item.getLabel();
            }

            @Override
            public boolean isVisible() {
                return this.hasData() && this.renderer.isSeriesVisible(this.item.getSeriesIndex());
            }

            @Override
            public boolean hasData() {
                Dataset dataset = this.item.getDataset();
                if (dataset instanceof TimeSeriesCollection) {
                    TimeSeriesCollection c = (TimeSeriesCollection)dataset;
                    TimeSeries s = c.getSeries(this.item.getSeriesIndex());
                    return !s.isEmpty();
                }
                return false;
            }

            @Override
            public void setVisible(boolean visible) {
                this.setVisible(visible, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean setVisible(boolean visible, boolean notify) {
                if (this.hasData()) {
                    Map map = map;
                    synchronized (map) {
                        ((boolean[])map.get((Object)((PlotSeriesVisibilityModelImpl)PlotSeriesVisibilityModelImpl.this).graphID))[this.item.getSeriesIndex()] = visible;
                    }
                    Boolean current = this.renderer.getSeriesVisible(this.item.getSeriesIndex());
                    if (current != null && current == visible) {
                        return false;
                    }
                    this.renderer.setSeriesVisible(this.item.getSeriesIndex(), visible, notify);
                    this.item.setLabelPaint(visible ? Color.BLACK : new Color(150, 150, 150));
                } else {
                    this.renderer.setSeriesVisible(this.item.getSeriesIndex(), false, notify);
                    this.item.setLabelPaint(new Color(230, 230, 230));
                }
                if (notify) {
                    PlotSeriesVisibilityModelImpl.this.fireChange();
                }
                return true;
            }

            @Override
            public Paint getPaint() {
                return this.renderer.getSeriesPaint(this.item.getSeriesIndex());
            }
        }
    }
}

