/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.utils.jfreechart.ChartExRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public final class PlotEx
extends XYPlot {
    private static final boolean TRACE_RENDERING = Boolean.getBoolean("TRACE_RENDERING");
    private final boolean forSlider;
    private final boolean hasLegend;

    public PlotEx(boolean forSlider, boolean hasLegend) {
        this.forSlider = forSlider;
        this.hasLegend = hasLegend;
    }

    void init(TimeSeriesCollection dataset, ChartExRenderer renderer) {
        this.setBackgroundPaint(Color.white);
        this.setDataset(dataset);
        this.setRenderer(renderer);
        TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        NumberAxis rangeAxis = new NumberAxis(renderer.getYLabel());
        NumberAxis domainAxis = new NumberAxis(renderer.getXLabel());
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        if (visibleTimeRangeModel != null) {
            domainAxis.setLowerBound(visibleTimeRangeModel.getMinimum(TimeUnit.NANOSECONDS));
            domainAxis.setUpperBound(visibleTimeRangeModel.getMaximum(TimeUnit.NANOSECONDS));
        }
        if (this.forSlider) {
            this.setRangeGridlinesVisible(false);
            this.setDomainGridlinesVisible(false);
            this.setInsets(RectangleInsets.ZERO_INSETS);
            this.setAxisOffset(RectangleInsets.ZERO_INSETS);
            this.setOutlineVisible(false);
            rangeAxis.setVisible(false);
            domainAxis.setVisible(false);
        } else {
            this.setRangeGridlinePaint(Color.gray);
            this.setDomainGridlinePaint(Color.gray);
            this.setNoDataMessage("No Data");
            this.setNoDataMessagePaint(Color.LIGHT_GRAY);
            this.setNoDataMessageFont(new Font("Arial", 0, 50));
        }
        if (this.hasLegend) {
            this.setFixedLegendItems(this.getLegendItems());
        }
        this.setDomainAxis(domainAxis);
        this.setRangeAxis(rangeAxis);
    }

    @Override
    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        XYDataset dataset;
        long start_time;
        long l = start_time = TRACE_RENDERING ? System.currentTimeMillis() : -1L;
        if (TRACE_RENDERING) {
            System.out.println(start_time + ": STARTED RENDERING");
        }
        if (DatasetUtils.isEmptyOrNull(dataset = this.getDataset(index))) {
            return false;
        }
        XYItemRenderer r = this.getRenderer();
        if (!(r instanceof ChartExRenderer)) {
            return super.render(g2, dataArea, index, info, crosshairState);
        }
        ChartExRenderer renderer = (ChartExRenderer)r;
        ValueAxis xAxis = this.getDomainAxisForDataset(index);
        ValueAxis yAxis = this.getRangeAxisForDataset(index);
        renderer.drawAllSeries(g2, dataArea, this, dataset, xAxis, yAxis, info);
        if (TRACE_RENDERING) {
            long end_time = System.currentTimeMillis();
            System.out.println(end_time + ": RENDERING DONE in " + (end_time - start_time) + " ms.");
            if (info != null) {
                EntityCollection entityCollection = info.getOwner().getEntityCollection();
                System.out.println(entityCollection.getEntityCount() + " entities added");
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PlotEx)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 47 * hash + (this.forSlider ? 1 : 0);
        hash = 47 * hash + (this.hasLegend ? 1 : 0);
        return hash;
    }
}

