/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.ChartExRenderer;
import com.azul.log.gui.utils.jfreechart.NumberAxisEx;
import com.azul.log.gui.utils.jfreechart.NumberFormatEx;
import com.azul.log.gui.utils.jfreechart.PlotEx;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.lang.ref.SoftReference;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public final class JFreeChartSupport {
    private static final ExecutorService RP = Executors.newCachedThreadPool();

    private JFreeChartSupport() {
    }

    public static boolean adjustFontSize(Component c, float fontSize) {
        if (!(c instanceof ChartPanel)) {
            return false;
        }
        ChartPanel cp = (ChartPanel)c;
        JFreeChart chart = cp.getChart();
        Stream stream = chart.getSubtitles().stream();
        stream.filter(LegendTitle.class::isInstance).map(LegendTitle.class::cast).forEachOrdered(t -> t.setItemFont(t.getItemFont().deriveFont(fontSize)));
        XYPlot plot = cp.getChart().getXYPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelFont(domainAxis.getTickLabelFont().deriveFont(fontSize - 2.0f));
        domainAxis.setLabelFont(domainAxis.getLabelFont().deriveFont(fontSize));
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setTickLabelFont(rangeAxis.getTickLabelFont().deriveFont(fontSize - 2.0f));
        rangeAxis.setLabelFont(rangeAxis.getLabelFont().deriveFont(fontSize));
        return true;
    }

    public static Range toJFCRange(TimeRange timeRange, TimeUnit timeUnit) {
        double start = timeRange.getStart().getInUnits(timeUnit);
        double end = timeRange.getEnd().getInUnits(timeUnit);
        return new Range(start, end);
    }

    public static TimeRange fromJFCRange(Range range, TimeUnit timeUnit) {
        long k = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        long start = (long)(range.getLowerBound() * (double)k);
        long end = (long)(range.getUpperBound() * (double)k);
        return new TimeRange(start, end, TimeUnit.NANOSECONDS);
    }

    public static ChartEx createXYGraph(GraphDefinition gd, boolean forSlider, boolean hasLegend) {
        TimeSeries[] timeSeries = JFreeChartSupport.initTimeSeries(gd);
        return JFreeChartSupport.createXYGraph(gd, timeSeries, forSlider, hasLegend);
    }

    public static ChartEx createXYGraph(GraphDefinition gd, TimeSeries[] timeSeries, boolean forSlider, boolean hasLegend) {
        boolean isMainChart;
        PlotEx plot = new PlotEx(forSlider, hasLegend);
        JFreeChart chart = new JFreeChart(gd.getCategoryName() + ": " + gd.getTitle(), JFreeChart.DEFAULT_TITLE_FONT, plot, hasLegend);
        ChartExRenderer.ChartRendererMode mode = forSlider ? ChartExRenderer.ChartRendererMode.SLIDER : (hasLegend ? ChartExRenderer.ChartRendererMode.MAIN : ChartExRenderer.ChartRendererMode.PREVIEW);
        ChartFactory.getChartTheme().apply(chart);
        ChartExRenderer renderer = new ChartExRenderer(gd, mode);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        List<DataSeries> graphData = gd.getGraphData();
        for (int idx = 0; idx < timeSeries.length; ++idx) {
            TimeSeries ts = timeSeries[idx];
            dataset.addSeries(ts);
            renderer.setSeriesPaint(idx, ts.isEmpty() ? new Color(230, 230, 230) : graphData.get(idx).getColor());
        }
        plot.init(dataset, renderer);
        final LogRecordLabelConverter labelConverter = gd.getLabelConverter();
        final NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        if (labelConverter != null) {
            rangeAxis.setTickUnit(new NumberTickUnit(1.0, new NumberFormatEx(){

                @Override
                public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                    return toAppendTo.append(labelConverter.convert(number));
                }
            }));
        } else {
            rangeAxis.setNumberFormatOverride(new NumberFormatEx(){

                @Override
                public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                    double size = rangeAxis.getTickUnit().getSize();
                    return toAppendTo.append(this.formatNumberForUnitSize(number, size));
                }
            });
        }
        boolean bl = isMainChart = !forSlider && hasLegend;
        if (isMainChart) {
            chart.getXYPlot().setDomainAxis(new NumberAxisEx());
        }
        return new ChartEx(gd, chart, isMainChart);
    }

    public static Shape createStarShape(double r_in, double r_out, int rays, double angle) {
        Path2D.Double path = new Path2D.Double();
        double step = Math.PI / (double)rays;
        ((Path2D)path).moveTo(Math.cos(angle) * r_out, Math.sin(angle) * r_out);
        for (int i = 1; i < rays + 1; ++i) {
            ((Path2D)path).lineTo(Math.cos(angle += step) * r_in, Math.sin(angle) * r_in);
            ((Path2D)path).lineTo(Math.cos(angle += step) * r_out, Math.sin(angle) * r_out);
        }
        path.closePath();
        return path;
    }

    public static TimeSeries[] initTimeSeries(GraphDefinition gd) {
        List<DataSeries> graphData = gd.getGraphData();
        TimeSeries[] result = new TimeSeries[graphData.size()];
        CountDownLatch latch = new CountDownLatch(graphData.size());
        for (int idx = 0; idx < graphData.size(); ++idx) {
            int ser_idx = idx;
            DataSeries ser = graphData.get(idx);
            SoftReference<?> ref = ser.getUserObjectRef();
            Object val = ref == null ? null : ref.get();
            long timeAdjustmentNano = gd.getLogModel().getTimeAdjustmentNano();
            if (val instanceof TimeSeriesImpl && ((TimeSeriesImpl)val).adjustment == timeAdjustmentNano) {
                result[ser_idx] = val;
                latch.countDown();
                continue;
            }
            RP.submit(() -> {
                try {
                    TimeAdjustmentSupport.withLogModel(gd.getLogModel(), () -> {
                        LogRecordsList<LogRecord> data = ser.getData();
                        LogDataConverter converter = ser.getConverter();
                        TimeSeriesImpl series = new TimeSeriesImpl(ser.getLabel(), data.size(), timeAdjustmentNano);
                        Iterator it = data.iterator();
                        while (it.hasNext()) {
                            LogRecord record = (LogRecord)it.next();
                            Double value = it.getAggregatedValue();
                            if (value == null) {
                                value = converter.getValue(record);
                            }
                            if (value == null) continue;
                            series.add(record, value);
                        }
                        ser.setUserObjectRef(new SoftReference<TimeSeriesImpl>(series));
                        result[ser_idx] = series;
                    });
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(JFreeChartSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private static class TimeSeriesImpl
    extends TimeSeries {
        private final long adjustment;

        public TimeSeriesImpl(String name, int size, long adjustment) {
            super((Comparable)((Object)name));
            super.setDescription(name);
            this.timePeriodClass = FixedMillisecond.class;
            this.adjustment = adjustment;
            ((ArrayList)this.data).ensureCapacity(size);
        }

        private void add(LogRecord record, Double value) {
            long ns = record.getEventRelativeTimestamp().getInUnits(TimeUnit.NANOSECONDS);
            this.data.add(new TimeSeriesDataItem((RegularTimePeriod)new FixedMillisecond(ns), value));
        }

        @Override
        public void update(int index, Number value) {
            throw new IllegalStateException();
        }

        @Override
        public TimeSeriesDataItem addOrUpdate(TimeSeriesDataItem item) {
            throw new IllegalStateException();
        }

        @Override
        public void removeAgedItems(boolean notify) {
            throw new IllegalStateException();
        }

        @Override
        public void removeAgedItems(long latest, boolean notify) {
            throw new IllegalStateException();
        }
    }
}

