/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.LogRecordElement;
import com.azul.log.gui.model.spi.InfoPanelContentProvider;
import com.azul.log.gui.support.RecordFieldTooltipSupport;
import com.azul.log.gui.utils.jfreechart.JFreeChartElementSelectionController;
import com.azul.log.model.api.FieldDescription;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.model.spi.LogRecordFieldsProvider;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import java.lang.reflect.Field;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class JFreeChartRecordElement
extends LogRecordElement {
    public final int totalItems;
    public final int itemIndex;
    public final int seriesIndex;
    public final GraphDefinition graphDefinition;

    private JFreeChartRecordElement(GraphDefinition graphDefinition, int seriesIndex, int itemIndex, int totalItems) {
        super(graphDefinition.getRecord(seriesIndex, itemIndex), graphDefinition.getLogModel());
        this.graphDefinition = graphDefinition;
        this.seriesIndex = seriesIndex;
        this.itemIndex = itemIndex;
        this.totalItems = totalItems;
        this.ic.add(JFreeChartElementSelectionController.get(graphDefinition));
    }

    public static JFreeChartRecordElement create(GraphDefinition graphDefinition, int seriesIndex, int itemIndex, int totalItems) {
        return TimeAdjustmentSupport.withLogModel(graphDefinition.getLogModel(), () -> new JFreeChartRecordElement(graphDefinition, seriesIndex, itemIndex, totalItems));
    }

    @Override
    public InfoPanelContentProvider.InfoPanelContent getInfoPanelContent() {
        Field fld = GraphsDefinitionProviderAccessor.getInstance().getField(this.graphDefinition, this.seriesIndex);
        return new InfoPanelContentImpl(fld);
    }

    public String getAsText() {
        DataSeries series = this.graphDefinition.getGraphData().get(this.seriesIndex);
        RelativeTimestamp eventTimestamp = this.record.getEventRelativeTimestamp();
        DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
        LogDataConverter converter = series.getConverter();
        return series.getLabel() + ": [" + dtm.toString(eventTimestamp, DateTimeFormatter.ISO_ZONED_DATE_TIME) + "; " + converter.getValueAsText(this.record, 4) + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof JFreeChartRecordElement) {
            JFreeChartRecordElement that = (JFreeChartRecordElement)obj;
            return this.seriesIndex == that.seriesIndex && this.itemIndex == that.itemIndex && this.graphDefinition.getID() == that.graphDefinition.getID();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.itemIndex;
        hash = 79 * hash + this.seriesIndex;
        hash = 79 * hash + Objects.hashCode(this.graphDefinition);
        return hash;
    }

    public static abstract class GraphsDefinitionProviderAccessor {
        private static volatile GraphsDefinitionProviderAccessor INSTANCE;

        private static GraphsDefinitionProviderAccessor getInstance() {
            if (INSTANCE == null) {
                try {
                    Class.forName(GraphsDefinitionProvider.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (INSTANCE == null) {
                    throw new IllegalStateException("Accessor not set");
                }
            }
            return INSTANCE;
        }

        public static void setInstance(GraphsDefinitionProviderAccessor instance) {
            if (instance == null) {
                throw new IllegalArgumentException();
            }
            if (INSTANCE != null) {
                throw new IllegalStateException("Accessor already set");
            }
            INSTANCE = instance;
        }

        protected abstract Field getField(GraphDefinition var1, int var2);
    }

    private class InfoPanelContentImpl
    implements InfoPanelContentProvider.InfoPanelContent {
        private static final String DERIVED_FROM_FIELD = "*";
        private static final String AGGREGATION_FIELD = "\u0192(";
        private final Field fld;
        private final String html;
        private final Set<Field> derivedFromFields;
        private final boolean derived;
        private final Aggregation aggregation;

        public InfoPanelContentImpl(Field fld) {
            this.fld = fld;
            FieldDescription fd = JFreeChartRecordElement.this.record.getFieldDescription(fld);
            this.derivedFromFields = fd.derivedFromFields();
            this.derived = !this.derivedFromFields.isEmpty();
            this.aggregation = JFreeChartRecordElement.this.graphDefinition.getGraphData().get(JFreeChartRecordElement.this.seriesIndex).getData().getAggregation();
            this.html = this.init();
        }

        @Override
        public LogRecord getRecord() {
            return JFreeChartRecordElement.this.record;
        }

        @Override
        public String getAsHtml() {
            return this.html;
        }

        private String init() {
            String line = JFreeChartRecordElement.this.getLogLineContent().trim();
            LogRecordFieldsProvider fp = Context.lookup(LogRecordFieldsProvider.class);
            if (fp == null) {
                return line;
            }
            Set<Field> fields = this.derived ? this.derivedFromFields : Collections.singleton(this.fld);
            List<LogRecordFieldsProvider.TextBounds> bounds = fp.getFieldsBounds(JFreeChartRecordElement.this.record.getClass(), line, fields);
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            for (LogRecordFieldsProvider.TextBounds bound : bounds) {
                int start = bound.getStart();
                int end = bound.getEnd();
                sb.append(line.subSequence(idx, start));
                sb.append("<b>");
                if (this.aggregation != Aggregation.UNSPECIFIED) {
                    sb.append(AGGREGATION_FIELD);
                    sb.append(line.subSequence(start, end));
                    sb.append(")");
                } else {
                    sb.append(line.subSequence(start, end));
                    if (this.derived) {
                        sb.append(DERIVED_FROM_FIELD);
                    }
                }
                sb.append("</b>");
                idx = end;
            }
            sb.append(line.subSequence(idx, line.length()));
            return sb.toString();
        }

        @Override
        public String getHtmlTooltip(String plainText, int charIndex) {
            LogRecordFieldsProvider provider = Context.lookup(LogRecordFieldsProvider.class);
            if (provider == null) {
                return null;
            }
            Field field = provider.getFieldAtChar(JFreeChartRecordElement.this.record.getClass(), plainText, charIndex);
            ArrayList<String> notes = new ArrayList<String>();
            if (this.fld.equals(field) && this.aggregation != Aggregation.UNSPECIFIED) {
                notes.add("This field is used for aggregation [f(x) = " + JFreeChartRecordElement.this.graphDefinition.getGraphData().get(JFreeChartRecordElement.this.seriesIndex).getData().getAggregation().name() + "]");
            }
            if (this.derivedFromFields.contains(field)) {
                notes.add("The selected value on the chart is derived from this field");
            }
            return RecordFieldTooltipSupport.getHTMLTooltip(this.getRecord(), field, notes);
        }
    }
}

