/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.actions.MarksActions;
import com.azul.log.gui.actions.ViewLogAction;
import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DataSeriesStatistics;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.PlotSeriesVisibilityModel;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.CustomTooltipSupport;
import com.azul.log.gui.ui.DisplayTimeUnitsSelector;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.Markline;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.FavoriteToggleButton;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.gui.utils.jfreechart.NumberAxisEx;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.support.TimeAdjustmentSupport;
import com.azul.log.utils.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.entity.AxisEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.openide.util.Lookup;

public final class ChartPanelEx
extends ChartPanel
implements Lookup.Provider {
    private final ChartEx chart;
    private final ChangeListenerImpl changeListener;
    private final MarksModel.MarksCategoryModel logMarklinesVisibilityModel;
    private final MarksModel marksModel;
    private final Lookup lookup = Lookup.EMPTY;
    private final boolean isMainPanel;
    private final DisplayTimeModel displayTimeModel;
    private final ChangeListener displayTimeModelListener;
    private final NumberFormat nf;
    private Point lastTooltipLocation;
    private ChartEntity lastEntity;

    public ChartPanelEx(ChartEx chart, boolean mouseZoomable, boolean mainPanel) {
        super(chart.getChart(), true);
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(100, 100));
        this.chart = chart;
        this.isMainPanel = mainPanel;
        this.marksModel = Context.lookup(MarksModel.class);
        this.logMarklinesVisibilityModel = this.marksModel.getCategoriesModel();
        LabelsVisibilitySupport labelsVisibilitySupport = new LabelsVisibilitySupport(this);
        this.setMouseZoomable(mouseZoomable);
        this.addChartMouseListener(new ChartMouseListenerImpl());
        if (this.isMainPanel) {
            JPopupMenu menu = this.getPopupMenu();
            menu.addSeparator();
            menu.add(labelsVisibilitySupport.getMenuPresenter());
            menu.addSeparator();
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Use GC Type-specific shapes", "USE_GC_TYPE_SPECIFIC_SHAPES"));
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Draw Selected Event Phases", "DRAW_EVENT_PHASES"));
            menu.add(UIUtils.createGCLAPropertyActivationMenuItem("Show Item# in Tooltips", "SHOW_ITEM_NUM_IN_TOOLTIP"));
        } else {
            this.setPopupMenu(null);
        }
        if (chart.isMainChart()) {
            final JPanel toggleButtonsPanel = new JPanel();
            toggleButtonsPanel.setOpaque(false);
            int id = chart.getGraphDefinition().getID();
            toggleButtonsPanel.add(new FavoriteToggleButton(id));
            LayoutManager layoutManager = new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return parent.getPreferredSize();
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return parent.getMinimumSize();
                }

                @Override
                public void layoutContainer(Container parent) {
                    Dimension preferred = toggleButtonsPanel.getPreferredSize();
                    toggleButtonsPanel.setBounds(parent.getWidth() - preferred.width, 0, preferred.width, preferred.height);
                }
            };
            this.setLayout(layoutManager);
            this.add(toggleButtonsPanel);
        }
        KeyStroke copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        KeyStroke shift_copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK | 0x40, false);
        this.registerKeyboardAction(new CopyJFreeChartElement(false), "COPY", copy, 0);
        this.registerKeyboardAction(new CopyJFreeChartElement(true), "COPY", shift_copy, 0);
        this.changeListener = new ChangeListenerImpl(chart);
        this.displayTimeModel = Context.lookup(DisplayTimeModel.class);
        this.displayTimeModelListener = e -> {
            NumberAxisEx axis = new NumberAxisEx();
            axis.setVisible(this.isMainPanel);
            chart.getChart().getXYPlot().setDomainAxis(axis);
        };
        this.nf = UIUtils.getNumberFormat();
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
    }

    ChartEntity getEntity(MouseEvent e) {
        ChartRenderingInfo info = this.getChartRenderingInfo();
        if (info == null) {
            return null;
        }
        EntityCollection entities = info.getEntityCollection();
        if (entities == null) {
            return null;
        }
        Insets insets = this.getInsets();
        return entities.getEntity((int)((double)(e.getX() - insets.left) / this.getScaleX()), (int)((double)(e.getY() - insets.top) / this.getScaleY()));
    }

    @Override
    public JToolTip createToolTip() {
        return CustomTooltipSupport.createTooltip(this);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        ChartEntity entity = this.getEntity(e);
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof LegendItemEntity)) {
            return entity.getToolTipText();
        }
        LegendItemEntity lie = (LegendItemEntity)entity;
        TimeRangeSelectionModel.VisibleTimeRangeModel vtrModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        TimeRange vtr = vtrModel.getSelection();
        String vtrString = vtr.toString();
        String tipText = lie.getToolTipText();
        if (tipText == null || !tipText.startsWith(vtrString)) {
            TimeSeriesCollection tsc = (TimeSeriesCollection)lie.getDataset();
            TimeSeries series = tsc.getSeries(lie.getSeriesKey());
            DataSeriesStatistics s = UIUtils.calculateStatistics(series, vtr);
            tipText = "<html><div style='border-bottom-width: 1; border-bottom-style: solid; border-bottom-color: gray; white-space:nowrap; font-weight: bold;'>" + series.getDescription() + "</div>";
            if (s != null) {
                tipText = tipText + this.toHTMLTable(s);
            }
            lie.setToolTipText(vtrString + tipText);
        } else {
            tipText = tipText.substring(vtrString.length());
        }
        return tipText;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        ChartEntity entity = this.getEntity(e);
        if (entity == null || entity.getToolTipText() == null) {
            this.lastEntity = null;
            return null;
        }
        if (!entity.equals(this.lastEntity)) {
            this.lastEntity = entity;
            JToolTip tip = this.createToolTip();
            tip.setTipText(this.getToolTipText(e));
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.add((Component)tip, "Center");
            tmp.doLayout();
            tmp.removeAll();
            Rectangle itemBounds = entity.getArea().getBounds();
            itemBounds.x = (int)((double)itemBounds.x * this.getScaleX());
            itemBounds.y = (int)((double)itemBounds.y * this.getScaleY());
            itemBounds.width = (int)((double)itemBounds.width * this.getScaleX());
            itemBounds.height = (int)((double)itemBounds.height * this.getScaleY());
            Point screenPoint = itemBounds.getLocation();
            SwingUtilities.convertPointToScreen(screenPoint, this);
            itemBounds.setLocation(screenPoint);
            Rectangle limitingBounds = UIUtils.shrinkRect(MainFrame.get().getBounds(), MainFrame.get().getInsets());
            Point screenLocation = UIUtils.placeTooltip(limitingBounds, itemBounds, tip.getPreferredSize());
            SwingUtilities.convertPointFromScreen(screenLocation, this);
            this.lastTooltipLocation = screenLocation;
        }
        return this.lastTooltipLocation;
    }

    private String toHTMLTable(DataSeriesStatistics s) {
        StatsEntry[] data = new StatsEntry[]{new StatsEntry("Min", s.min), new StatsEntry("Max", s.max), new StatsEntry("Q1", s.q1), new StatsEntry("Mean", s.mean), new StatsEntry("Median", s.median), new StatsEntry("Q3", s.q3)};
        Arrays.sort(data, Comparator.comparingDouble(s2 -> ((StatsEntry)s2).value));
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='tooltip' align='center'>");
        sb.append("<tr><th style='padding: 10 5 10 5;' colspan='2'>Selected TimeRange Statistics</th></tr>");
        sb.append("<tr>");
        sb.append("<td style='padding: 0 5 10 5'>Items:</td>");
        sb.append("<td style='padding: 0 5 10 5'>").append(s.numberOfElements).append("</td>");
        sb.append("</tr>");
        for (StatsEntry e : data) {
            sb.append("<tr><td style='padding: 0 5 0 5'>");
            sb.append(e.name);
            sb.append(":</td><td style='padding: 0 5 0 5'>");
            sb.append(this.formatNumber(e.value)).append("</td></tr>");
        }
        sb.append("<tr>");
        sb.append("<td style='padding: 10 5 0 5'>Outliers:</td>");
        sb.append("<td style='padding: 10 5 0 5'>").append(s.numberOfOutliers).append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td style='padding: 0 5 0 5'>Min Regular Value:</td>");
        sb.append("<td style='padding: 0 5 0 5'>").append(this.formatNumber(s.minRegularValue)).append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td style='padding: 0 5 10 5'>Max Regular Value:</td>");
        sb.append("<td style='padding: 0 5 10 5'>").append(this.formatNumber(s.maxRegularValue)).append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    private String formatNumber(double value) {
        this.nf.setMaximumFractionDigits(value > 1.0 ? 2 : 6);
        return this.nf.format(value);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.marksModel.addChangeListener(this.changeListener);
        this.logMarklinesVisibilityModel.addChangeListener(this.changeListener);
        this.displayTimeModel.addChangeListener(this.displayTimeModelListener);
        this.displayTimeModelListener.stateChanged(null);
        Config.addPropertyChangeListener("DRAW_EVENT_PHASES", this.changeListener);
        Config.addPropertyChangeListener("USE_GC_TYPE_SPECIFIC_SHAPES", this.changeListener);
    }

    @Override
    public void removeNotify() {
        Config.removePropertyChangeListener("USE_GC_TYPE_SPECIFIC_SHAPES", this.changeListener);
        Config.removePropertyChangeListener("DRAW_EVENT_PHASES", this.changeListener);
        this.logMarklinesVisibilityModel.removeChangeListener(this.changeListener);
        this.marksModel.removeChangeListener(this.changeListener);
        this.displayTimeModel.removeChangeListener(this.displayTimeModelListener);
        super.removeNotify();
    }

    @Override
    public void restoreAutoDomainBounds() {
        TimeRangeSelectionModel.VisibleTimeRangeModel model = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        if (model != null) {
            model.selectAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSaveAs() throws IOException {
        FileDialog dialog = new FileDialog((Frame)SwingUtilities.windowForComponent(this));
        dialog.setTitle("Save Image As");
        String dir = Config.getLastSelectedDir();
        if (dir == null) {
            dir = ".";
        }
        dialog.setDirectory(dir);
        dialog.setMode(1);
        dialog.setMultipleMode(false);
        dialog.setFile(this.chart.getGraphDefinition().getDefaultSaveAsFileName() + ".png");
        dialog.setVisible(true);
        try {
            String fileName = dialog.getFile();
            if (fileName == null) {
                return;
            }
            if (!fileName.endsWith(".png")) {
                fileName = fileName + ".png";
            }
            File file = new File(dialog.getDirectory(), fileName);
            Config.setLastSelectedDir(file.getParentFile().getAbsolutePath());
            BufferedImage bufferedImage = this.getChart().createBufferedImage(this.getWidth(), this.getHeight(), new ChartRenderingInfo());
            ImageIO.write((RenderedImage)bufferedImage, "png", Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        finally {
            dialog.dispose();
        }
    }

    public void copyToClipboard() {
        try (final ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            BufferedImage rawImage = this.getChart().createBufferedImage(this.getWidth(), this.getHeight(), 1, new ChartRenderingInfo());
            ImageWriter writer = ImageIO.getImageWritersByFormatName("PNG").next();
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            params.setCompressionQuality(0.0f);
            writer.setOutput(ImageIO.createImageOutputStream(bos));
            writer.write(null, new IIOImage(rawImage, Collections.emptyList(), null), params);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.allHtmlFlavor, DataFlavor.imageFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return false;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    if (DataFlavor.imageFlavor.equals(flavor)) {
                        try {
                            return ImageIO.read(new ByteArrayInputStream(bos.toByteArray()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (DataFlavor.allHtmlFlavor.equals(flavor)) {
                        return "<img src=\"data:image/png;base64," + CommonUtils.encodeBase64(bos.toByteArray()) + "\"/>";
                    }
                    return "";
                }
            }, null);
        }
        catch (IOException ex) {
            Logger.getLogger(ChartPanelEx.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    private class ChartMouseListenerImpl
    implements ChartMouseListener {
        private ChartMouseListenerImpl() {
        }

        @Override
        public void chartMouseClicked(ChartMouseEvent cme) {
            TimeAdjustmentSupport.withLogModel(ChartPanelEx.this.chart.getGraphDefinition().getLogModel(), () -> this.chartMouseClickedEx(cme));
        }

        private void chartMouseClickedEx(ChartMouseEvent cme) {
            MouseEvent trigger = cme.getTrigger();
            ChartEntity entity = cme.getEntity();
            if (trigger.getButton() != 1) {
                return;
            }
            final UIElementSelectionModel selectionModel = UIElementSelectionModel.getInstance();
            if (entity instanceof XYItemEntity) {
                XYItemEntity e = (XYItemEntity)entity;
                JFreeChartRecordElement elem = ChartPanelEx.this.chart.createInfoElementFor(e);
                selectionModel.setSelectedElement(elem);
                if (trigger.getClickCount() == 2) {
                    new ViewLogAction().actionPerformed((ActionEvent)null);
                }
            } else if (entity instanceof LegendItemEntity) {
                PlotSeriesVisibilityModel model = Context.lookup(PlotSeriesVisibilityModel.class);
                if (model != null) {
                    PlotSeriesVisibilityModel.SeriesInfo info;
                    LegendItemEntity e = (LegendItemEntity)entity;
                    XYDataset dataset = (XYDataset)e.getDataset();
                    int index = dataset.indexOf(e.getSeriesKey());
                    info.setVisible(!(info = model.getSeriesInfoData().get(index)).isVisible());
                }
            } else if (entity instanceof AxisEntity) {
                NumberAxisEx numberAxis;
                Shape labelBounds;
                Axis axis = ((AxisEntity)entity).getAxis();
                if (axis instanceof NumberAxisEx && (labelBounds = (numberAxis = (NumberAxisEx)axis).getLabelBounds()) != null && labelBounds.contains(trigger.getPoint())) {
                    JPopupMenu menu = new JPopupMenu();
                    DisplayTimeUnitsSelector selector = new DisplayTimeUnitsSelector();
                    for (Component menuComponent : selector.getMenuComponents()) {
                        menu.add(menuComponent);
                    }
                    Rectangle r = labelBounds.getBounds();
                    menu.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            ChartPanelEx.this.repaint();
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    });
                    menu.show(ChartPanelEx.this, r.x, r.y + r.height);
                }
            } else if (entity instanceof Markline) {
                Markline markline = (Markline)entity;
                final Mark mark = markline.getMark();
                if (ChartPanelEx.this.isMainPanel && trigger.isShiftDown()) {
                    if (trigger.isAltDown()) {
                        boolean visible = !markline.isLabelVisible();
                        String category = markline.getMark().getCategory();
                        Collection allEntities = ChartPanelEx.this.getChartRenderingInfo().getEntityCollection().getEntities();
                        Stream<Markline> marklines = allEntities.stream().filter(Markline.class::isInstance).map(Markline.class::cast);
                        marklines.filter(m -> m.getMark().getCategory().equals(category)).forEach(m -> m.setLabelVisible(visible));
                    } else {
                        markline.changeLabelVisibility();
                    }
                } else {
                    if (mark.isUserMark() && markline.isSelected() && markline.isLabelVisible() && trigger.getClickCount() == 1) {
                        Point labelLocation = cme.getEntity().getArea().getBounds().getLocation();
                        final Point point = ChartPanelEx.this.translateJava2DToScreen(labelLocation);
                        final String label = mark.getLabel();
                        final JTextField fld = new JTextField(label);
                        fld.setBackground(Markline.AttributesProvider.getLineColor(mark));
                        fld.setForeground(Markline.AttributesProvider.getLabelColor(mark));
                        final Graphics2D g = (Graphics2D)ChartPanelEx.this.getGraphics();
                        final FontMetrics fm = g.getFontMetrics(fld.getFont());
                        Rectangle textBound = fm.getStringBounds(label, g).getBounds();
                        int dx = 3;
                        int dy = -2;
                        Rectangle fldBounds = new Rectangle(3 + point.x, -2 + point.y, 11 + textBound.width, 6 + textBound.height);
                        if (fldBounds.contains(trigger.getPoint())) {
                            try {
                                fld.setBorder(new EmptyBorder(2, 6, 2, 4));
                                fld.setSelectionStart(0);
                                fld.setSelectionEnd(label.length());
                                fld.setBounds(fldBounds);
                                mark.setLabel("", false);
                                ChartPanelEx.this.getChart().fireChartChanged();
                                MarksActions.enable(false);
                                final AtomicBoolean cancelled = new AtomicBoolean(false);
                                InputMap im = fld.getInputMap();
                                ActionMap am = fld.getActionMap();
                                im.put(KeyStroke.getKeyStroke(27, 0), "cancel");
                                im.put(KeyStroke.getKeyStroke(10, 0), "submit");
                                am.put("cancel", new AbstractAction(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        cancelled.set(true);
                                        ChartPanelEx.this.remove(fld);
                                    }
                                });
                                am.put("submit", new AbstractAction(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        mark.setLabel(fld.getText(), true);
                                        ChartPanelEx.this.remove(fld);
                                    }
                                });
                                fld.getDocument().addDocumentListener(new DocumentListener(){

                                    private void update() {
                                        Rectangle textBound = fm.getStringBounds(fld.getText(), g).getBounds();
                                        fld.setBounds(3 + point.x, -2 + point.y, 11 + textBound.width, 6 + textBound.height);
                                    }

                                    @Override
                                    public void insertUpdate(DocumentEvent e) {
                                        this.update();
                                    }

                                    @Override
                                    public void removeUpdate(DocumentEvent e) {
                                        this.update();
                                    }

                                    @Override
                                    public void changedUpdate(DocumentEvent e) {
                                        this.update();
                                    }
                                });
                                fld.addFocusListener(new FocusAdapter(){

                                    @Override
                                    public void focusLost(FocusEvent e) {
                                        mark.setLabel(cancelled.get() ? label : fld.getText(), !cancelled.get());
                                        ChartPanelEx.this.remove(fld);
                                        MarksActions.enable(true);
                                        selectionModel.update(mark);
                                        ChartPanelEx.this.getChart().fireChartChanged();
                                    }
                                });
                                ChartPanelEx.this.add(fld);
                                SwingUtilities.invokeLater(fld::requestFocusInWindow);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(ChartPanelEx.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    selectionModel.setSelectedElement(mark);
                    if (trigger.getClickCount() == 2) {
                        List<LogFile> logFiles = Context.lookup(LogFilesModel.class).getLogFiles();
                        for (LogFile logFile : logFiles) {
                            LogModel logModel = logFile.lookup(LogModel.class);
                            if (!mark.belongsTo(logModel)) continue;
                            new ViewLogAction().openLog(logModel);
                            break;
                        }
                    }
                }
            } else if (trigger.getClickCount() == 2) {
                ChartPanelEx.this.actionPerformed(new ActionEvent(ChartPanelEx.this, 0, "ZOOM_RESET_RANGE"));
            }
            ChartPanelEx.this.requestFocusInWindow();
        }

        @Override
        public void chartMouseMoved(ChartMouseEvent cme) {
            NumberAxisEx numberAxis;
            Shape labelBounds;
            Axis axis;
            ChartEntity entity = cme.getEntity();
            if (entity instanceof LegendItemEntity) {
                ChartPanelEx.this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            if (entity instanceof AxisEntity && (axis = ((AxisEntity)entity).getAxis()) instanceof NumberAxisEx && (labelBounds = (numberAxis = (NumberAxisEx)axis).getLabelBounds()) != null && labelBounds.contains(cme.getTrigger().getPoint())) {
                ChartPanelEx.this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            ChartPanelEx.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private final class LabelsVisibilitySupport {
        private final JMenu menu = new JMenu("Marklines");
        private final JMenuItem showMarkLabel;
        private final JMenuItem hideMarkLabel;
        private final JMenuItem showCategoryLabel;
        private final JMenuItem hideCategoryLabel;
        private final JMenuItem showAllLabels;
        private final JMenuItem hideAllLabels;
        private Mark activeMark;

        public LabelsVisibilitySupport(ChartPanel panel) {
            AbstractAction a = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean show;
                    Object source = e.getSource();
                    Collection allEntities = ChartPanelEx.this.getChartRenderingInfo().getEntityCollection().getEntities();
                    Stream<Markline> marklines = allEntities.stream().filter(Markline.class::isInstance).map(Markline.class::cast);
                    boolean bl = show = LabelsVisibilitySupport.this.showAllLabels.equals(source) || LabelsVisibilitySupport.this.showCategoryLabel.equals(source) || LabelsVisibilitySupport.this.showMarkLabel.equals(source);
                    if (LabelsVisibilitySupport.this.showAllLabels.equals(source) || LabelsVisibilitySupport.this.hideAllLabels.equals(source)) {
                        marklines.forEach(m -> m.setLabelVisible(show));
                    } else if (LabelsVisibilitySupport.this.showMarkLabel.equals(source) || LabelsVisibilitySupport.this.hideMarkLabel.equals(source)) {
                        marklines.filter(m -> LabelsVisibilitySupport.this.activeMark == m.getMark()).findFirst().ifPresent(m -> m.setLabelVisible(show));
                    } else if (LabelsVisibilitySupport.this.showCategoryLabel.equals(source) || LabelsVisibilitySupport.this.hideCategoryLabel.equals(source)) {
                        String category = LabelsVisibilitySupport.this.activeMark.getCategory();
                        marklines.filter(m -> category.equals(m.getMark().getCategory())).forEach(m -> m.setLabelVisible(show));
                    }
                    ChartPanelEx.this.getChart().fireChartChanged();
                }
            };
            UIElementSelectionModel.getInstance().addChangeListener(e -> this.activate(UIElementSelectionModel.getInstance().getSelectedElement()));
            this.showMarkLabel = this.add(this.menu, "Show Label of Selected Markline", a);
            this.hideMarkLabel = this.add(this.menu, "Hide Label of Selected Markline", a);
            this.showCategoryLabel = this.add(this.menu, "Show Labels of Selected Markline Category", a);
            this.hideCategoryLabel = this.add(this.menu, "Hide Labels of Selected Markline Category", a);
            this.showAllLabels = this.add(this.menu, "Show Labels of All Marklines", a);
            this.hideAllLabels = this.add(this.menu, "Hide Labels of All Marklines", a);
            this.activate(null);
        }

        private JMenuItem add(JMenu menu, String text, Action action) {
            JMenuItem item = new JMenuItem(action);
            item.setText(text);
            menu.add(item);
            return item;
        }

        private void activate(Object entity) {
            this.activeMark = (Mark)(entity instanceof Mark ? entity : null);
            boolean enableActions = this.activeMark != null;
            this.showMarkLabel.setEnabled(enableActions);
            this.showCategoryLabel.setEnabled(enableActions);
            this.hideMarkLabel.setEnabled(enableActions);
            this.hideCategoryLabel.setEnabled(enableActions);
        }

        public JMenu getMenuPresenter() {
            return this.menu;
        }
    }

    private static class StatsEntry {
        private final String name;
        private final double value;

        public StatsEntry(String name, double value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class ChangeListenerImpl
    implements ChangeListener,
    PropertyChangeListener {
        private final JFreeChart chart;

        public ChangeListenerImpl(ChartEx chart) {
            this.chart = chart.getChart();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.chart.fireChartChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.chart.fireChartChanged();
        }
    }

    private static class CopyJFreeChartElement
    implements ActionListener {
        private final boolean withRecord;

        public CopyJFreeChartElement(boolean withRecord) {
            this.withRecord = withRecord;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIElement sel = UIElementSelectionModel.getInstance().getSelectedElement();
            if (sel instanceof JFreeChartRecordElement) {
                JFreeChartRecordElement elem = (JFreeChartRecordElement)sel;
                StringBuilder text = new StringBuilder();
                text.append(elem.getAsText());
                if (this.withRecord) {
                    text.append('\n');
                    text.append(sel.getLogLineContent());
                }
                UIUtils.copyTextToClipboard(text.toString());
            }
        }
    }
}

