/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.model.DataSeriesStatistics;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.utils.FontSizeAdjuster;
import com.azul.log.utils.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultEditorKit;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public final class UIUtils {
    public static final int MENU_SHORTCUT_KEY_MASK = Boolean.getBoolean("java.awt.headless") ? 0 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final String AUTO_SCALE_PROPERTY = "autoscale";
    private static final int toolTipOffset = 5;

    private UIUtils() {
    }

    public static NumberFormat getNumberFormat() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        assert (numberFormat != null) : "Unexpected to have null here";
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols custom = new DecimalFormatSymbols();
            custom.setDecimalSeparator('.');
            custom.setGroupingSeparator('\u200a');
            ((DecimalFormat)numberFormat).setDecimalFormatSymbols(custom);
        }
        return (NumberFormat)numberFormat.clone();
    }

    public static void setupLookAndFeel() {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!"Nimbus".equals(info.getName())) continue;
            try {
                UIManager.setLookAndFeel(info.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                Logger.getLogger(UIUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            break;
        }
    }

    public static void setupApplicationDockIcon(Image icon) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> klass = Class.forName("com.apple.eawt.Application");
            MethodType mt = MethodType.methodType(klass);
            MethodHandle mh = lookup.findStatic(klass, "getApplication", mt);
            Object app = mh.invoke();
            mt = MethodType.methodType(Void.TYPE, Image.class);
            mh = lookup.findVirtual(klass, "setDockIconImage", mt);
            mh.invoke(app, icon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setupFontAdjuster(Integer fontSize) {
        int size = fontSize == null ? 12 : fontSize;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        boolean do_scale = System.getProperty("hidpi") != null ? Boolean.getBoolean("hidpi") : CommonUtils.isLinux();
        float scale = do_scale ? Math.max((float)dim.width / 1920.0f, (float)dim.height / 1080.0f) : 1.0f;
        Toolkit.getDefaultToolkit().addAWTEventListener(new FontSizeAdjuster(size, scale), 2L);
    }

    public static void setupTooltips() {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.setDismissDelay((int)TimeUnit.MILLISECONDS.convert(40L, TimeUnit.SECONDS));
        ttm.setReshowDelay(0);
        ttm.setInitialDelay(0);
        Color color = Config.getColorProperty("ToolTip.background", Color.decode("#f2f2bd"));
        UIManager.put("ToolTip.background", color);
    }

    public static Image loadImage(String name) {
        return UIUtils.loadIcon(name).getImage();
    }

    public static ImageIcon loadIcon(String name) {
        URL url = UIUtils.class.getResource("/images" + name);
        if (url == null) {
            url = UIUtils.class.getResource("/images/unknown.png");
            Logger.getLogger(UIUtils.class.getName()).log(Level.WARNING, "Cannot load icon {0}", name);
        }
        return new ImageIcon(Objects.requireNonNull(url));
    }

    public static List<Image> loadImages(String ... names) {
        return Arrays.stream(names).map(UIUtils::loadImage).collect(Collectors.toList());
    }

    public static ImageIcon scaledImage(String resource, int w, int h) {
        ImageIcon img = UIUtils.loadIcon(resource);
        if (w == 0 && h != 0) {
            w = img.getIconWidth() * h / img.getIconHeight();
        } else if (h == 0 && w != 0) {
            h = img.getIconHeight() * w / img.getIconWidth();
        }
        return new ImageIcon(img.getImage().getScaledInstance(w, h, 16));
    }

    public static <T extends JComponent> T fixCopyPasteActionHotKeys(T component) {
        Action pasteAction;
        Action copyAction;
        Action cutAction;
        if (component == null) {
            return null;
        }
        if (component instanceof JTable) {
            cutAction = TransferHandler.getCutAction();
            copyAction = TransferHandler.getCopyAction();
            pasteAction = TransferHandler.getPasteAction();
        } else {
            cutAction = new DefaultEditorKit.CutAction();
            copyAction = new DefaultEditorKit.CopyAction();
            pasteAction = new DefaultEditorKit.PasteAction();
        }
        component.registerKeyboardAction(cutAction, KeyStroke.getKeyStroke(88, MENU_SHORTCUT_KEY_MASK, false), 1);
        component.registerKeyboardAction(copyAction, KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK, false), 1);
        component.registerKeyboardAction(pasteAction, KeyStroke.getKeyStroke(86, MENU_SHORTCUT_KEY_MASK, false), 1);
        return component;
    }

    public static void copyTextToClipboard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(text), null);
    }

    public static String toHTMLColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static double getDistance(Point p, Rectangle r) {
        if (p.x < r.x) {
            if (p.y < r.y) {
                return p.distance(r.getLocation());
            }
            if (p.y > r.y + r.height) {
                return p.distance(r.x, r.y + r.height);
            }
            return r.x - p.x;
        }
        if (p.x > r.x + r.width) {
            if (p.y < r.y) {
                return p.distance(r.x + r.width, r.y);
            }
            if (p.y > r.y + r.height) {
                return p.distance(r.x + r.width, r.y + r.height);
            }
            return p.x - r.x - r.width;
        }
        if (p.y < r.y) {
            return r.y - p.y;
        }
        if (p.y > r.y + r.height) {
            return p.y - r.y - r.height;
        }
        return 0.0;
    }

    public static Rectangle shrinkRect(Rectangle bounds, Insets insets) {
        return new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
    }

    public static Point placeTooltip(Rectangle bounds, Rectangle item, Dimension tipSize) {
        Rectangle tip = new Rectangle(tipSize.width, tipSize.height);
        tip.setLocation(item.x + 5, item.y - tipSize.height - 5);
        UIUtils.adjustToBounds(bounds, tip);
        if (!tip.intersects(item)) {
            return tip.getLocation();
        }
        tip.setLocation(item.x + item.width + 5, bounds.y + bounds.height - tipSize.height);
        UIUtils.adjustToBounds(bounds, tip);
        if (!tip.intersects(item)) {
            return tip.getLocation();
        }
        tip.setLocation(item.x - tipSize.width - 5, bounds.y + bounds.height - tipSize.height);
        UIUtils.adjustToBounds(bounds, tip);
        if (!tip.intersects(item)) {
            return tip.getLocation();
        }
        tip.setLocation(item.x + 5, item.y + item.height + 5);
        UIUtils.adjustToBounds(bounds, tip);
        return tip.getLocation();
    }

    private static void adjustToBounds(Rectangle bounds, Rectangle tip) {
        int x = tip.x - Math.max(0, tip.x + tip.width - (bounds.x + bounds.width));
        int y = tip.y - Math.max(0, tip.y + tip.height - (bounds.y + bounds.height));
        tip.setLocation(x, y);
    }

    public static void convertRectToScreen(Rectangle rect, Component c) {
        Point loc = rect.getLocation();
        SwingUtilities.convertPointToScreen(loc, c);
        rect.setLocation(loc);
    }

    public static JMenuItem createGCLAPropertyActivationMenuItem(String label, String propertyName) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
        item.setSelected(Config.isActive(propertyName));
        item.addActionListener(e -> Config.setActive(propertyName, item.isSelected()));
        return item;
    }

    public static DataSeriesStatistics calculateStatistics(TimeSeries ds, TimeRange visibleTimeRange) {
        if (ds.isEmpty()) {
            return null;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        ArrayList<Double> values = new ArrayList<Double>(ds.getItemCount());
        for (Object item : ds.getItems()) {
            TimeSeriesDataItem dataItem = (TimeSeriesDataItem)item;
            RegularTimePeriod period = dataItem.getPeriod();
            long from = visibleTimeRange.getStart().getInUnits(TimeUnit.NANOSECONDS);
            long to = visibleTimeRange.getEnd().getInUnits(TimeUnit.NANOSECONDS);
            if (period.getMiddleMillisecond() < from) continue;
            if (period.getMiddleMillisecond() > to) break;
            double v = dataItem.getValue().doubleValue();
            values.add(v);
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        if (values.isEmpty()) {
            return null;
        }
        BoxAndWhiskerItem s = BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(values);
        return new DataSeriesStatistics(values.size(), s.getMean().doubleValue(), max, min, s.getMedian().doubleValue(), s.getQ1().doubleValue(), s.getQ3().doubleValue(), s.getMinRegularValue().doubleValue(), s.getMaxRegularValue().doubleValue(), s.getMinOutlier().doubleValue(), s.getMaxOutlier().doubleValue(), s.getOutliers().size());
    }

    public static void showMessageWithURL(String title, String message, String link, final String url, int type, Icon icon) {
        JPanel panel = new JPanel(new GridBagLayout());
        Color bg = panel.getBackground();
        UIUtils.fixCopyPasteActionHotKeys(panel);
        JTextArea msg = new JTextArea(message);
        msg.setEditable(false);
        msg.setBorder(null);
        msg.setCaretPosition(0);
        msg.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue() + 1));
        JLabel downloadURL = new JLabel(link);
        downloadURL.setForeground(Color.blue);
        downloadURL.setCursor(Cursor.getPredefinedCursor(12));
        Font font = downloadURL.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        downloadURL.setFont(font.deriveFont(attributes));
        downloadURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                }
                catch (UnsupportedOperationException ex) {
                    int answer = JOptionPane.showConfirmDialog(MainFrame.get(), ex.getMessage() + "\nCopy URL to the system clipboard?", "Unable to open external Browser", 0, 0);
                    if (answer == 0) {
                        UIUtils.copyTextToClipboard(url);
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(UIUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel.add((Component)msg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panel.add((Component)downloadURL, gridBagConstraints);
        JOptionPane pane = new JOptionPane(panel, type, 0, icon, new String[0], null);
        JDialog dialog = pane.createDialog(MainFrame.get(), title);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static <T extends JComponent> T autoScale(T component) {
        component.putClientProperty(AUTO_SCALE_PROPERTY, Boolean.TRUE);
        return component;
    }

    public static boolean isAutoScale(JComponent component) {
        return Boolean.TRUE.equals(component.getClientProperty(AUTO_SCALE_PROPERTY));
    }
}

