/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.SearchTextActions;
import com.azul.log.gui.model.Model;
import com.azul.log.gui.search.SearchProgressListener;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.utils.ChangeSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public final class TextSearchPanel
extends JPanel
implements Model,
SearchProgressListener {
    private static final String FIND_NEXT = "searchForward";
    private static final String FIND_PREVIOUS = "searchBackward";
    private static final String CANCEL = "cancel";
    private final ChangeSupport cs = new ChangeSupport(this);
    private final AtomicInteger progressBarDisplayCount = new AtomicInteger(0);
    private final JComponent focusOwner;
    private final JToggleButton btnCase;
    private final JButton btnNext;
    private final JButton btnPrev;
    private final JProgressBar progressBar;
    private final JComboBox<String> textBox = UIUtils.fixCopyPasteActionHotKeys(new JComboBox());
    private Boolean isCaseSensitive = false;
    private Timer progressBarDisplayTimer;

    public TextSearchPanel(JComponent focusOwner) {
        this.btnPrev = new JButton();
        this.btnNext = new JButton();
        this.btnCase = new JToggleButton();
        this.progressBar = new JProgressBar();
        this.focusOwner = focusOwner;
        final AtomicBoolean searchCancelled = new AtomicBoolean(false);
        ActionListener listener = e -> {
            String command = e.getActionCommand();
            if (CANCEL.equals(command)) {
                SearchTextActions.CANCEL.actionPerformed(e);
                if (searchCancelled.get()) {
                    this.btnCancelActionPerformed(e);
                } else {
                    searchCancelled.set(true);
                    this.textBox.getEditor().selectAll();
                    this.textBox.requestFocusInWindow();
                }
                return;
            }
            searchCancelled.set(false);
            this.textBox.setPopupVisible(false);
            String text = this.getSearchText();
            if (!text.isEmpty()) {
                this.textBox.removeItem(text);
                this.textBox.insertItemAt(text, 0);
                this.textBox.setSelectedItem(text);
            }
            switch (command) {
                case "searchForward": {
                    this.btnNext.getAction().actionPerformed(e);
                    break;
                }
                case "searchBackward": {
                    this.btnPrev.getAction().actionPerformed(e);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        };
        this.initComponents();
        this.textBox.setModel(new DefaultComboBoxModel());
        this.setCaseSensitive(this.isCaseSensitive);
        JTextComponent editor = (JTextComponent)this.textBox.getEditor().getEditorComponent();
        editor.registerKeyboardAction(listener, FIND_NEXT, KeyStroke.getKeyStroke(10, 0), 0);
        editor.registerKeyboardAction(listener, FIND_PREVIOUS, KeyStroke.getKeyStroke(10, 64), 0);
        this.registerKeyboardAction(listener, CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        KeyStroke copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        KeyStroke cut = KeyStroke.getKeyStroke(88, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        KeyStroke selectAll = KeyStroke.getKeyStroke(65, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
        InputMap im = editor.getInputMap(0);
        im.put(copy, "copy-to-clipboard");
        im.put(paste, "paste-from-clipboard");
        im.put(cut, "cut-to-clipboard");
        im.put(selectAll, "select-all");
        im.put(KeyStroke.getKeyStroke(77, 64, false), "ignore");
        editor.getActionMap().put("ignore", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.textBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 27) {
                    searchCancelled.set(false);
                    TextSearchPanel.this.cs.fireChange();
                }
            }
        });
        this.progressBar.setVisible(false);
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(max);
        int currentCount = this.progressBarDisplayCount.get();
        this.progressBarDisplayTimer = new Timer(500, e -> {
            if (currentCount == this.progressBarDisplayCount.get()) {
                this.progressBar.setVisible(true);
            }
        });
        this.progressBarDisplayTimer.start();
    }

    @Override
    public void setProgress(int value) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
    }

    @Override
    public void stopProgress() {
        this.progressBarDisplayCount.incrementAndGet();
        this.progressBarDisplayTimer.stop();
        this.progressBar.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.textBox.requestFocusInWindow();
        }
        this.cs.fireChange();
    }

    public String getSearchText() {
        return ((JTextComponent)this.textBox.getEditor().getEditorComponent()).getText();
    }

    void setSearchText(String text) {
        this.textBox.setSelectedItem(text);
        this.textBox.getEditor().selectAll();
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private void setCaseSensitive(Boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
        this.btnCase.setSelected(caseSensitive);
        this.btnCase.setToolTipText(caseSensitive != false ? "Switch to Case-Insensitive Search" : "Switch to Case-Sensitive Search");
        this.cs.fireChange();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout(0, 3, 3));
        JLabel label = new JLabel("Find Text:");
        label.setLabelFor(this.textBox);
        leftPanel.add(label);
        this.textBox.setEditable(true);
        this.textBox.setPreferredSize(new Dimension(450, 28));
        leftPanel.add(UIUtils.autoScale(this.textBox));
        this.btnPrev.setAction(SearchTextActions.FIND_PREV);
        this.btnPrev.setText("");
        this.btnPrev.setToolTipText("Find Previous Entry (Shift-ENTER)");
        this.btnPrev.setHideActionText(true);
        this.btnPrev.setIcon(UIUtils.loadIcon("/search/arrow_up.png"));
        leftPanel.add(UIUtils.autoScale(this.btnPrev));
        this.btnNext.setAction(SearchTextActions.FIND_NEXT);
        this.btnNext.setToolTipText("Find Next Entry (ENTER)");
        this.btnNext.setHideActionText(true);
        this.btnNext.setIcon(UIUtils.loadIcon("/search/arrow_down.png"));
        leftPanel.add(UIUtils.autoScale(this.btnNext));
        this.btnCase.setToolTipText("");
        this.btnCase.setHideActionText(true);
        this.btnCase.addActionListener(this::btnCaseActionPerformed);
        this.btnCase.setIcon(UIUtils.loadIcon("/search/case-sensitive.png"));
        leftPanel.add(UIUtils.autoScale(this.btnCase));
        leftPanel.add(this.progressBar);
        this.add((Component)leftPanel, "West");
        JButton btnCancel = new JButton();
        btnCancel.setToolTipText("Close Search Bar (Esc)");
        btnCancel.setContentAreaFilled(false);
        btnCancel.setPreferredSize(new Dimension(36, 32));
        btnCancel.addActionListener(this::btnCancelActionPerformed);
        btnCancel.setIcon(UIUtils.loadIcon("/search/close.png"));
        this.add((Component)UIUtils.autoScale(btnCancel), "East");
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.focusOwner.requestFocusInWindow();
    }

    private void btnCaseActionPerformed(ActionEvent evt) {
        this.setCaseSensitive(this.btnCase.isSelected());
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }
}

