/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.ParserExceptionsModel;
import com.azul.log.gui.model.api.LogLocation;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.ParserExceptionsPanel;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class StatusBar
extends JPanel {
    private static final String ICON_WARNING_RAISED = "/buttons/warning_raised.png";
    private static final String ICON_WARNING = "/buttons/warning.png";
    private final Lookup.Result<LogLocation> positionInfoLookupResult = Context.lookupResult(LogLocation.class);
    private final Lookup.Result<LogModel> logModelLookupResult = Context.lookupResult(LogModel.class);
    private final ChangeListener exceptionsListener;
    private String filePath = null;
    private int lineInFile = 0;
    private JLabel lblFileName;
    private JLabel lblLineNumber;
    private JButton openExceptions;

    public StatusBar() {
        LookupListenerImpl lookupListener = new LookupListenerImpl();
        this.positionInfoLookupResult.addLookupListener(lookupListener);
        this.logModelLookupResult.addLookupListener(lookupListener);
        this.initComponents();
        this.exceptionsListener = e -> {
            boolean hasExceptions;
            boolean bl = hasExceptions = !ParserExceptionsModel.getModel().getExceptions().isEmpty();
            if (hasExceptions) {
                this.openExceptions.setToolTipText("View Parsing Errors");
                this.openExceptions.setIcon(UIUtils.loadIcon(ICON_WARNING_RAISED));
                this.openExceptions.setEnabled(true);
            } else {
                this.openExceptions.setToolTipText("No Parsing Errors");
                this.openExceptions.setIcon(UIUtils.loadIcon(ICON_WARNING));
                this.openExceptions.setEnabled(false);
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ParserExceptionsModel.getModel().addChangeListener(this.exceptionsListener);
        this.exceptionsListener.stateChanged(null);
    }

    @Override
    public void removeNotify() {
        ParserExceptionsModel.getModel().removeChangeListener(this.exceptionsListener);
        super.removeNotify();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        this.lblFileName = new JLabel();
        JLabel fileNameLabel = new JLabel("File Name:");
        fileNameLabel.setLabelFor(this.lblFileName);
        leftPanel.add(fileNameLabel);
        this.lblFileName.setCursor(new Cursor(12));
        this.lblFileName.addMouseListener(new FileNameMouseListener());
        leftPanel.add(this.lblFileName);
        JSeparator s1 = new JSeparator(1);
        s1.setPreferredSize(new Dimension(12, 15));
        leftPanel.add(s1);
        this.lblLineNumber = new JLabel();
        JLabel lineNumberLabel = new JLabel("Line:");
        lineNumberLabel.setLabelFor(this.lblLineNumber);
        leftPanel.add(lineNumberLabel);
        this.lblLineNumber.setCursor(new Cursor(12));
        this.lblLineNumber.addMouseListener(new LineNumberMouseListener());
        leftPanel.add(this.lblLineNumber);
        JSeparator s2 = new JSeparator(1);
        s2.setPreferredSize(new Dimension(12, 15));
        leftPanel.add(s2);
        this.add((Component)leftPanel, "West");
        JPanel rightPanel = new JPanel(new BorderLayout(5, 0));
        this.openExceptions = new JButton();
        this.openExceptions.setIcon(UIUtils.loadIcon(ICON_WARNING));
        this.openExceptions.setBorderPainted(false);
        this.openExceptions.setContentAreaFilled(false);
        this.openExceptions.addActionListener(this::openExceptionsActionPerformed);
        rightPanel.add((Component)this.openExceptions, "Center");
        this.add((Component)rightPanel, "East");
    }

    private void openExceptionsActionPerformed(ActionEvent evt) {
        this.openExceptions.setIcon(UIUtils.loadIcon(ICON_WARNING));
        JOptionPane p = new JOptionPane(new ParserExceptionsPanel());
        JDialog d = p.createDialog(MainFrame.get(), "Parsing Errors");
        d.setResizable(true);
        d.setVisible(true);
        d.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                StatusBar.this.openExceptions.setIcon(UIUtils.loadIcon(StatusBar.ICON_WARNING_RAISED));
            }
        });
    }

    private class LineNumberMouseListener
    extends MouseAdapter {
        private LineNumberMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            StatusBar.this.lblLineNumber.setForeground(Color.blue);
            evt.consume();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            StatusBar.this.lblLineNumber.setForeground(Color.black);
            evt.consume();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (StatusBar.this.lineInFile > 0) {
                UIUtils.copyTextToClipboard(Integer.toString(StatusBar.this.lineInFile));
            }
            evt.consume();
        }
    }

    private class FileNameMouseListener
    extends MouseAdapter {
        private FileNameMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            StatusBar.this.lblFileName.setForeground(Color.blue);
            evt.consume();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            StatusBar.this.lblFileName.setForeground(Color.black);
            evt.consume();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (StatusBar.this.filePath != null) {
                if (evt.isShiftDown() && StatusBar.this.lineInFile > 0) {
                    UIUtils.copyTextToClipboard(StatusBar.this.filePath + " +" + StatusBar.this.lineInFile);
                    return;
                }
                UIUtils.copyTextToClipboard(StatusBar.this.filePath);
            }
        }
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            int p;
            LogModel logModel;
            Path path;
            LogLocation logLocation = Context.lookup(LogLocation.class);
            StatusBar.this.lineInFile = logLocation == null ? -1 : logLocation.getLineInFile();
            this.setLineNumber(StatusBar.this.lineInFile);
            String fileName = null;
            StatusBar.this.filePath = null;
            if (logLocation != null && (path = logLocation.getFilePath()) != null) {
                StatusBar.this.filePath = path.toString();
                fileName = path.getFileName().toString();
            }
            if (fileName == null && (logModel = Context.lookup(LogModel.class)) != null && (p = (fileName = logModel.getLogName()).indexOf(" [")) > 0) {
                fileName = fileName.substring(0, p);
            }
            this.setFileName(fileName, StatusBar.this.filePath, StatusBar.this.lineInFile);
        }

        private void setFileName(String fileName, String fullPath, int line) {
            StatusBar.this.lblFileName.setText(fileName);
            StatusBar.this.lblFileName.setEnabled(fullPath != null);
            if (fileName == null || fullPath == null) {
                StatusBar.this.lblFileName.setToolTipText(null);
                return;
            }
            String hint = "Click to copy path to Clipboard";
            if (line > 0) {
                hint = hint + "<br>" + KeyEvent.getModifiersExText(64) + "+Click to copy path +line to Clipboard";
            }
            StatusBar.this.lblFileName.setToolTipText(this.createTooltip("Full Path: " + fullPath, hint));
        }

        private void setLineNumber(int line) {
            if (line <= 0) {
                StatusBar.this.lblLineNumber.setText(null);
                StatusBar.this.lblLineNumber.setToolTipText(null);
            } else {
                StatusBar.this.lblLineNumber.setText(Integer.toString(line));
                StatusBar.this.lblLineNumber.setToolTipText(this.createTooltip("Line number in the current file", "Click to copy to Clipboard"));
            }
        }

        private String createTooltip(String value, String hint) {
            return String.format("<html>%s<br><br><i><font color='gray'>%s</font></i></p>", value, hint);
        }
    }
}

