/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.FavoriteGraphsModel;
import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.ui.QuickSearchPanel;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.ui.nodes.GraphNode;
import com.azul.log.gui.ui.nodes.Node;
import com.azul.log.gui.ui.nodes.TableNode;
import com.azul.log.gui.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.font.TextMeasurer;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public abstract class SelectionPanel<T extends Node>
extends JPanel
implements Lookup.Provider {
    private static final ImageIcon favoriteIcon = UIUtils.loadIcon("/favorite.png");
    private static final ImageIcon emptyIcon = new ImageIcon(new BufferedImage(10, 10, 2));
    protected final JTree tree;
    private final TreeSelectionListener tsl = new TreeSelectionListenerImpl();
    private final ProxyLookup.Controller lookupController = new ProxyLookup.Controller();
    private final Lookup lookup = new ProxyLookup(this.lookupController);
    private SelectionPanel<?> peerPanel;

    protected SelectionPanel() {
        super(new BorderLayout());
        this.lookupController.setLookups(Lookup.EMPTY);
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        if (this.tree.getUI().getClass() == SynthTreeUI.class) {
            SynthTreeUI teeUI = new SynthTreeUI(){

                @Override
                protected int getRowX(int row, int depth) {
                    int offset = SelectionPanel.this.getRowXOffset(row, depth);
                    return offset == -1 ? super.getRowX(row, depth) : offset;
                }
            };
            this.tree.setUI(teeUI);
        }
        InputMap im = this.tree.getInputMap();
        ActionMap am = this.tree.getActionMap();
        im.put(KeyStroke.getKeyStroke(38, 0), "selectPreviousAvailable");
        im.put(KeyStroke.getKeyStroke(40, 0), "selectNextAvailable");
        am.put("selectNextAvailable", new SelectNodeAction(1));
        am.put("selectPreviousAvailable", new SelectNodeAction(-1));
        this.tree.setCellRenderer(new RendererImpl());
        this.tree.setSelectionModel(new SelectionModelImpl());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        ScrollBarUIEx.setup(scrollPane, true);
        super.add((Component)scrollPane, "Center");
        QuickSearchPanel searchTextPanel = new QuickSearchPanel(this.tree);
        super.add((Component)searchTextPanel, "South");
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public void setPeerPanel(SelectionPanel<?> peer) {
        this.peerPanel = peer;
    }

    protected void updateModel() {
        TreeNode root = this.createRootNode();
        this.tree.setModel(new DefaultTreeModel(root));
        this.expandAllNodes(this.tree);
    }

    protected int getRowXOffset(int row, int depth) {
        return -1;
    }

    protected abstract TreeNode createRootNode();

    protected void clearSelection() {
        this.tree.clearSelection();
    }

    protected boolean renderTags() {
        return false;
    }

    private boolean isPathSelectable(TreePath path) {
        DefaultMutableTreeNode treeNode;
        Object userObject;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof Node) {
            Node node = (Node)userObject;
            GraphDefinition gd = node.getLookup().lookup(GraphDefinition.class);
            if (gd != null) {
                return gd.hasData();
            }
            TableDefinition td = node.getLookup().lookup(TableDefinition.class);
            if (td != null) {
                return td.hasData();
            }
        }
        return true;
    }

    private void expandAllNodes(JTree tree) {
        int j = tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            tree.expandRow(i);
            j = tree.getRowCount();
        }
    }

    protected void setLookup(Lookup lookup) {
        this.lookupController.setLookups(Lookup.EMPTY);
        this.lookupController.setLookups(lookup);
    }

    private final class RendererImpl
    extends DefaultTreeCellRenderer {
        private final WeakHashMap<String, ImageIcon> tagIcons = new WeakHashMap();
        private float tagIconWidth = -1.0f;
        private float tagIconHeight = -1.0f;

        private RendererImpl() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (o instanceof GraphNode) {
                String tag;
                this.setFont(this.getFont().deriveFont(0));
                GraphNode gn = (GraphNode)o;
                GraphDefinition gd = gn.getLookup().lookup(GraphDefinition.class);
                if (gd == null) {
                    return this;
                }
                this.setEnabled(gd.hasData());
                this.setForeground(Color.black);
                ImageIcon icon = SelectionPanel.this.renderTags() && (tag = gn.getTag()) != null ? (sel ? this.createTagIcon(tag, Color.white) : this.tagIcons.computeIfAbsent(tag, t -> this.createTagIcon(tag, Color.blue))) : (FavoriteGraphsModel.getModel().contains(gd.getID()) ? favoriteIcon : emptyIcon);
                this.setIcon(icon);
            } else if (o instanceof TableNode) {
                this.setFont(this.getFont().deriveFont(0));
                TableNode tn = (TableNode)o;
                TableDefinition td = tn.getLookup().lookup(TableDefinition.class);
                if (td != null) {
                    this.setEnabled(td.hasData());
                }
            } else {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }

        private ImageIcon createTagIcon(String tag, Color color) {
            Rectangle2D sb;
            Graphics2D g2d;
            BufferedImage img;
            if (this.tagIconWidth < 0.0f) {
                img = new BufferedImage(100, 100, 2);
                g2d = (Graphics2D)img.getGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                sb = this.measureString("88888", g2d);
                this.tagIconWidth = (float)sb.getWidth() + 2.0f;
                this.tagIconHeight = (float)sb.getHeight() + 6.0f;
            }
            img = new BufferedImage((int)this.tagIconWidth, (int)this.tagIconHeight, 2);
            g2d = (Graphics2D)img.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(color);
            sb = this.measureString(tag, g2d);
            g2d.drawString(tag, (float)((double)this.tagIconWidth - sb.getWidth() - 4.0), this.tagIconHeight - 3.0f);
            g2d.dispose();
            return new ImageIcon(img);
        }

        private Rectangle2D measureString(String str, Graphics2D g2d) {
            AttributedString text = new AttributedString(str);
            AttributedCharacterIterator iterator = text.getIterator();
            TextMeasurer tm = new TextMeasurer(iterator, g2d.getFontRenderContext());
            return tm.getLayout(0, iterator.getEndIndex()).getBounds();
        }
    }

    private final class SelectNodeAction
    extends AbstractAction {
        private final int direction;

        private SelectNodeAction(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath current = SelectionPanel.this.tree.getSelectionPath();
            if (current == null) {
                return;
            }
            for (int rowToSelect = SelectionPanel.this.tree.getRowForPath(current) + this.direction; 0 <= rowToSelect && rowToSelect < SelectionPanel.this.tree.getRowCount(); rowToSelect += this.direction) {
                TreePath newPath = SelectionPanel.this.tree.getPathForRow(rowToSelect);
                if (!SelectionPanel.this.isPathSelectable(newPath)) continue;
                SelectionPanel.this.tree.setSelectionPath(newPath);
                Rectangle r = Objects.requireNonNull(SelectionPanel.this.tree.getPathBounds(newPath));
                SelectionPanel.this.tree.scrollRectToVisible(new Rectangle(0, r.y, 10, r.height));
                break;
            }
        }
    }

    private final class SelectionModelImpl
    extends DefaultTreeSelectionModel {
        public SelectionModelImpl() {
            this.setSelectionMode(1);
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            if (pPaths.length == 1 && SelectionPanel.this.isPathSelectable(pPaths[0])) {
                super.setSelectionPaths(pPaths);
                SelectionPanel.this.tsl.valueChanged(null);
            }
        }
    }

    private final class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object selection;
            SelectionPanel.this.peerPanel.clearSelection();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SelectionPanel.this.tree.getLastSelectedPathComponent();
            Object object = selection = node == null ? null : node.getUserObject();
            if (selection instanceof Node) {
                Node n = (Node)selection;
                SelectionPanel.this.setLookup(n.getLookup());
            } else {
                SelectionPanel.this.setLookup(Lookup.EMPTY);
            }
        }
    }
}

