/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicScrollBarUI;

final class ScrollBarUIEx
extends BasicScrollBarUI {
    private static final int size = 7;
    private final Dimension d = new Dimension();

    ScrollBarUIEx() {
    }

    static void setup(JScrollPane scrollPane, boolean withBorder) {
        scrollPane.setBorder(withBorder ? new LineBorder(Color.gray, 1) : null);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(7, Integer.MAX_VALUE));
        scrollPane.getVerticalScrollBar().setUI(new ScrollBarUIEx());
        scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(Integer.MAX_VALUE, 7));
        scrollPane.getHorizontalScrollBar().setUI(new ScrollBarUIEx());
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return ScrollBarUIEx.this.d;
            }
        };
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return ScrollBarUIEx.this.d;
            }
        };
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JScrollBar sb = (JScrollBar)c;
        if (!sb.isEnabled()) {
            return;
        }
        g2.setPaint(Color.gray);
        if (r.width < r.height) {
            g2.fillRoundRect(r.x, r.y + 10, r.width, r.height - 20, 5, 5);
        } else {
            g2.fillRoundRect(r.x + 10, r.y, r.width - 20, r.height, 5, 5);
        }
        g2.dispose();
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
        this.scrollbar.repaint();
    }
}

