/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.ui.RangeSlider;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

final class RangeSliderUI
extends BasicSliderUI {
    private final Shape thumbShape = new Ellipse2D.Double(1.0, 1.0, 12.0, 12.0);
    private final Dimension thumbSize = new Dimension(14, 14);
    private final Rectangle upperThumbRect;
    private final Rectangle selectionRect;
    private final RangeSlider rangeSlider;
    private transient boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;
    private BufferedImage img;
    private TimeRange lastTimeSelection;

    public RangeSliderUI(RangeSlider rangeSlider) {
        super(rangeSlider);
        if (rangeSlider.getOrientation() != 0) {
            throw new IllegalArgumentException("Unsupported slider orientation");
        }
        this.rangeSlider = rangeSlider;
        this.selectionRect = new Rectangle();
        this.upperThumbRect = new Rectangle(this.thumbSize.width, this.thumbSize.height);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        int x = this.xPositionForValue(this.rangeSlider.getValue() + this.rangeSlider.getExtent());
        this.upperThumbRect.x = x - this.upperThumbRect.width / 2;
        this.upperThumbRect.y = this.trackRect.y;
        int left = this.thumbRect.x + this.thumbRect.width / 2;
        int right = this.upperThumbRect.x + this.upperThumbRect.width / 2;
        this.selectionRect.setBounds(left, 0, right - left, this.rangeSlider.getHeight());
    }

    @Override
    protected Dimension getThumbSize() {
        return this.thumbSize;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle bounds = c.getBounds();
        int w = bounds.width;
        int h = bounds.height;
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            this.img = this.rangeSlider.createBackgroundImage(w, h);
        }
        this.paintTrack(g);
        this.paintThumb(g);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.drawImage((Image)this.img, 0, 0, null);
        int x = this.trackRect.x;
        int y = this.trackRect.y + this.trackRect.height / 2;
        g2d.setColor(this.getShadowColor());
        g2d.drawLine(x, y, x + this.trackRect.width, y);
        int h = this.rangeSlider.getHeight();
        int w = this.rangeSlider.getWidth();
        g2d.setColor(Color.DARK_GRAY);
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.2f));
        g2d.fillRect(0, 0, this.thumbRect.x + this.thumbRect.width / 2, h);
        g2d.fillRect(this.upperThumbRect.x + this.upperThumbRect.width / 2, 0, w, h);
        g2d.dispose();
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.upperThumbSelected) {
            this.paintThumb(this.thumbRect, g);
            this.paintThumb(this.upperThumbRect, g);
        } else {
            this.paintThumb(this.upperThumbRect, g);
            this.paintThumb(this.thumbRect, g);
        }
    }

    private void paintThumb(Rectangle knobBounds, Graphics g) {
        if (!g.getClipBounds().intersects(knobBounds)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setClip(knobBounds);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(Color.GRAY);
        g2d.fill(this.thumbShape);
        g2d.setColor(Color.DARK_GRAY);
        g2d.draw(this.thumbShape);
        g2d.dispose();
    }

    private void setUpperThumbLocation(int x, int y) {
        Rectangle r = new Rectangle(this.upperThumbRect);
        this.upperThumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, r);
        this.rangeSlider.repaint(r.x, r.y, r.width, r.height);
    }

    private final class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        private transient int upper_offset;

        private RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            boolean lowerHandleHit = RangeSliderUI.this.thumbRect.contains(x, y);
            boolean upperHandleHit = RangeSliderUI.this.upperThumbRect.contains(x, y);
            boolean selectionHit = false;
            if (lowerHandleHit && upperHandleHit) {
                lowerHandleHit = !RangeSliderUI.this.upperThumbSelected;
                upperHandleHit = RangeSliderUI.this.upperThumbSelected;
            } else if (lowerHandleHit || upperHandleHit) {
                RangeSliderUI.this.upperThumbSelected = upperHandleHit;
            } else if (RangeSliderUI.this.selectionRect.contains(x, y)) {
                selectionHit = true;
                RangeSliderUI.this.upperThumbSelected = false;
            }
            RangeSliderUI.this.lowerDragging = selectionHit || lowerHandleHit;
            RangeSliderUI.this.upperDragging = selectionHit || upperHandleHit;
            if (RangeSliderUI.this.lowerDragging) {
                this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
            }
            if (RangeSliderUI.this.upperDragging) {
                this.upper_offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.x;
            }
            this.currentMouseX = x;
            this.currentMouseY = y;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RangeSliderUI.this.lowerDragging = (RangeSliderUI.this.upperDragging = false);
            RangeSliderUI.this.rangeSlider.setValueIsAdjusting(false);
            if (e.getClickCount() == 2 && !e.isConsumed() && RangeSliderUI.this.selectionRect.contains(this.currentMouseX, this.currentMouseY)) {
                TimeRangeSelectionModel.VisibleTimeRangeModel model = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
                if (model != null) {
                    TimeRange selection = model.getSelection();
                    if (RangeSliderUI.this.lastTimeSelection != null) {
                        model.setSelection(RangeSliderUI.this.lastTimeSelection);
                    } else {
                        model.selectAll();
                    }
                    RangeSliderUI.this.lastTimeSelection = selection;
                }
                e.consume();
            }
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                return;
            }
            RangeSliderUI.this.rangeSlider.setValueIsAdjusting(true);
            RangeSliderUI.this.lastTimeSelection = null;
            if (RangeSliderUI.this.lowerDragging) {
                this.moveLowerThumb();
            }
            if (RangeSliderUI.this.upperDragging) {
                this.moveUpperThumb();
            }
            RangeSliderUI.this.rangeSlider.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (RangeSliderUI.this.upperThumbRect.contains(x, y) || RangeSliderUI.this.thumbRect.contains(x, y)) {
                RangeSliderUI.this.rangeSlider.setCursor(Cursor.getDefaultCursor());
            } else if (RangeSliderUI.this.selectionRect.contains(x, y)) {
                RangeSliderUI.this.rangeSlider.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                RangeSliderUI.this.rangeSlider.setCursor(Cursor.getDefaultCursor());
            }
            this.currentMouseX = x;
            this.currentMouseY = y;
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
            int thumbLeft = this.currentMouseX - this.offset;
            int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
            int trackRight = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.rangeSlider.getValue() + RangeSliderUI.this.rangeSlider.getExtent());
            int shift = RangeSliderUI.this.upperDragging ? ((RangeSliderUI)RangeSliderUI.this).selectionRect.width : 0;
            thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth - shift);
            thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
            RangeSliderUI.this.setThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
            RangeSliderUI.this.rangeSlider.setValue(RangeSliderUI.this.valueForXPosition(thumbLeft + halfThumbWidth));
        }

        private void moveUpperThumb() {
            int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
            int thumbLeft = this.currentMouseX - this.upper_offset;
            int trackLeft = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.rangeSlider.getValue());
            int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
            int shift = RangeSliderUI.this.lowerDragging ? ((RangeSliderUI)RangeSliderUI.this).selectionRect.width : 0;
            thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth + shift);
            thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
            RangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
            RangeSliderUI.this.rangeSlider.setExtent(RangeSliderUI.this.valueForXPosition(thumbLeft + halfThumbWidth) - RangeSliderUI.this.rangeSlider.getValue());
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.rangeSlider.repaint();
            }
        }
    }
}

