/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.ui.MainFrame;
import com.azul.log.utils.ProgressModel;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public final class ProgressBar
extends ProgressMonitor {
    private static final int RESOLUTION = 5000;
    private final ProgressModel model;
    private final Timer timer;

    private ProgressBar(String message, ProgressModel model) {
        super(MainFrame.get(), message, null, 0, 5000);
        this.model = model;
        this.setMillisToDecideToPopup(0);
        this.setMillisToPopup(0);
        this.timer = new Timer(100, e -> {
            this.setProgress((int)(model.getProgress() * 5000.0));
            if (this.isCanceled()) {
                model.cancel();
            }
        });
    }

    public static ProgressBar create(String message) {
        ProgressBar progressBar = new ProgressBar(message, new ProgressModel());
        progressBar.start();
        return progressBar;
    }

    private void start() {
        this.timer.start();
    }

    @Override
    public void close() {
        this.timer.stop();
        super.close();
    }

    public ProgressModel getProgressModel() {
        return this.model;
    }
}

