/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.PlotSeriesVisibilityModel;
import com.azul.log.gui.ui.PopupButton;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JPopupMenu;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

public final class PlotSeriesSelector
extends PopupButton {
    private final Lookup.Result<PlotSeriesVisibilityModel> lookupResult;

    public PlotSeriesSelector() {
        super(UIUtils.loadIcon("/buttons/select_data.png"));
        this.setToolTipText("Select Data Series");
        this.lookupResult = Context.lookupResult(PlotSeriesVisibilityModel.class);
        LookupListener listener = e -> this.setEnabled(Context.lookup(PlotSeriesVisibilityModel.class) != null);
        this.lookupResult.addLookupListener(listener);
        listener.resultChanged(null);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        PlotSeriesVisibilityModel visibilityModel = Context.lookup(PlotSeriesVisibilityModel.class);
        JPopupMenu menu = new JPopupMenu();
        List<PlotSeriesVisibilityModel.SeriesInfo> info = visibilityModel.getSeriesInfoData();
        if (!info.isEmpty()) {
            menu.setLayout(new GridLayout(info.size() + 3, 1));
            info.stream().map(x$0 -> new ShowSeriesItem((PlotSeriesVisibilityModel.SeriesInfo)x$0)).forEach(menu::add);
            menu.add(new JPopupMenu.Separator());
            menu.add(new ShowAllItem(visibilityModel, true));
            menu.add(new ShowAllItem(visibilityModel, false));
        }
        return menu;
    }

    private static final class ShowAllItem
    extends PopupButton.CustomJCheckBox {
        private final PlotSeriesVisibilityModel visibilityModel;

        private ShowAllItem(PlotSeriesVisibilityModel model, boolean show) {
            super((show ? "Show" : "Hide") + " All Series", true);
            this.visibilityModel = model;
            this.initListeners(show);
        }

        private void initListeners(boolean show) {
            this.addActionListener(e -> {
                for (Component c : this.getParent().getComponents()) {
                    if (!(c instanceof ShowSeriesItem)) continue;
                    ((ShowSeriesItem)c).setSelected(show);
                }
                this.visibilityModel.showAll(show);
            });
        }
    }

    private static final class ShowSeriesItem
    extends PopupButton.PopupMenuItem {
        private final PlotSeriesVisibilityModel.SeriesInfo info;

        private ShowSeriesItem(PlotSeriesVisibilityModel.SeriesInfo info) {
            super(info.getLabel(), info.isVisible(), info.getPaint());
            this.info = info;
            this.setEnabled(info.hasData());
        }

        @Override
        protected void performItemAction() {
            this.info.setVisible(this.isSelected());
        }
    }
}

