/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.markup.api.HTMLMarkup;
import com.azul.log.gui.markup.impl.TextHighlightProvider;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.TextSearchContext;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.TextProvider;
import com.azul.log.gui.model.spi.TooltipProvider;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.ui.TextSearchPanel;
import com.azul.log.gui.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleText;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openide.util.Lookup;

public final class LogSummaryPanel
extends ContentPanel
implements ChangeListener {
    private final JTable table;
    private final List<Integer> groupHeaders = new ArrayList<Integer>();
    private final JLabel groupHeader;
    private final TextSearchPanel searchPanel;
    private final LogSummaryToUIModelConverter summaryConverter;
    private DisplayTimeModel dtm;

    private LogSummaryPanel(LogSummaryToUIModelConverter summaryConverter) {
        super(Lookup.EMPTY);
        this.setLayout(new BorderLayout());
        this.summaryConverter = summaryConverter;
        this.groupHeader = new JLabel();
        this.groupHeader.setBorder(new EmptyBorder(0, 5, 0, 0){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.DARK_GRAY);
                g.translate(0, LogSummaryPanel.this.table.getRowHeight() - 1);
                g.drawLine(0, 0, c.getWidth(), 0);
            }
        });
        DefaultTableModel model = new DefaultTableModel(0, 2);
        this.table = new JTable(model);
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        this.table.setDefaultEditor(Object.class, null);
        this.table.setTableHeader(null);
        this.table.setBackground(Color.WHITE);
        UIUtils.fixCopyPasteActionHotKeys(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        ScrollBarUIEx.setup(scrollPane, false);
        this.add((Component)scrollPane, "Center");
        this.ic.add(new TextSearchContextImpl());
        this.searchPanel = new TextSearchPanel(this.table);
        this.searchPanel.setVisible(false);
        TextHighlightProvider.setText("", false);
        this.searchPanel.addChangeListener(e -> {
            String text = this.searchPanel.isVisible() ? this.searchPanel.getSearchText() : "";
            TextHighlightProvider.setText(text, this.searchPanel.isCaseSensitive());
            this.table.invalidate();
            this.table.repaint();
        });
        this.add((Component)this.searchPanel, "South");
    }

    public static LogSummaryPanel create(LogSummaryToUIModelConverter converter) {
        return new LogSummaryPanel(converter);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font font = this.table.getFont();
        this.groupHeader.setFont(font.deriveFont(1));
        FontMetrics metrics = this.table.getFontMetrics(font);
        this.table.setRowHeight(metrics.getHeight());
        this.summaryConverter.addListener(this);
        this.dtm = Context.lookup(DisplayTimeModel.class);
        if (this.dtm != null) {
            this.dtm.addChangeListener(this);
        }
        this.stateChanged(null);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.summaryConverter.removeListener(this);
        if (this.dtm != null) {
            this.dtm.removeChangeListener(this);
        }
    }

    private void setColumnWidths() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int width = 300;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TableCellRenderer renderer = this.table.getCellRenderer(i, 0);
            Component comp = this.table.prepareRenderer(renderer, i, 0);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        columnModel.getColumn(0).setPreferredWidth(width += 20);
        columnModel.getColumn(0).setMaxWidth(width);
        this.table.setAutoResizeMode(2);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateTableModel();
    }

    private void updateTableModel() {
        DefaultTableModel model = new DefaultTableModel(0, 2);
        this.groupHeaders.clear();
        SummaryCallback cb = new SummaryCallback(model);
        this.summaryConverter.convert(cb);
        this.table.setModel(model);
        this.setColumnWidths();
    }

    private class SummaryCallback
    extends LogSummaryToUIModelConverter.Callback {
        private final DefaultTableModel model;

        public SummaryCallback(DefaultTableModel model) {
            this.model = model;
        }

        @Override
        public void addSection(String sectionName) {
            if (this.model.getRowCount() > 0) {
                this.model.addRow(new Object[]{"", ""});
            }
            this.model.addRow(new Object[]{sectionName, null});
            LogSummaryPanel.this.groupHeaders.add(this.model.getRowCount() - 1);
        }

        @Override
        public void addValue(String name, Object value) {
            this.model.addRow(new Object[]{name, value == null ? "n/a" : value});
        }

        @Override
        public void addIndent() {
            this.model.addRow(new Object[]{"", ""});
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private final HTMLMarkup htmlMarkup = new HTMLMarkup();
        private Object value;

        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String html;
            this.value = value;
            if (LogSummaryPanel.this.groupHeaders.contains(row)) {
                LogSummaryPanel.this.groupHeader.setText(column == 0 ? (String)value : "");
                return LogSummaryPanel.this.groupHeader;
            }
            if (value instanceof TextProvider) {
                TextProvider provider = (TextProvider)value;
                html = this.htmlMarkup.highlight(null, (String)(isSelected ? provider.asText() : provider.asHtml()), (boolean)isSelected).html;
            } else {
                html = this.htmlMarkup.highlight((Object)value, (String)String.valueOf((Object)value), (boolean)isSelected).html;
            }
            return super.getTableCellRendererComponent(table, HTMLMarkup.decorate(html), isSelected, hasFocus, row, column);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (this.value instanceof TooltipProvider) {
                TooltipProvider provider = (TooltipProvider)this.value;
                AccessibleText accessibleText = this.getAccessibleContext().getAccessibleText();
                int xcoord = event.getX() - this.getInsets().left;
                if (xcoord >= 0) {
                    for (int i = 2; i < accessibleText.getCharCount(); ++i) {
                        if (xcoord >= accessibleText.getCharacterBounds((int)i).x) continue;
                        return provider.getTooltipAtChar(i - 2);
                    }
                }
            }
            return null;
        }
    }

    private class TextSearchContextImpl
    implements TextSearchContext {
        private String searchText;

        private TextSearchContextImpl() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void find() {
            LogSummaryPanel.this.searchPanel.setSearchText(this.searchText);
            LogSummaryPanel.this.searchPanel.setVisible(true);
        }

        @Override
        public void findNext() {
            this.search(1);
        }

        @Override
        public void findPrevious() {
            this.search(-1);
        }

        private void search(int lineIncrement) {
            boolean isCaseInsensitive;
            this.searchText = LogSummaryPanel.this.searchPanel.getSearchText();
            if (this.searchText.isEmpty()) {
                this.find();
                return;
            }
            int startRow = Math.max(0, LogSummaryPanel.this.table.getSelectedRow());
            int rowCount = LogSummaryPanel.this.table.getModel().getRowCount();
            int columnCount = LogSummaryPanel.this.table.getModel().getColumnCount();
            int row = startRow + lineIncrement;
            boolean bl = isCaseInsensitive = !LogSummaryPanel.this.searchPanel.isCaseSensitive();
            if (isCaseInsensitive) {
                this.searchText = this.searchText.toLowerCase();
            }
            while (row != startRow) {
                for (int col = 0; col < columnCount; ++col) {
                    String text = String.valueOf(LogSummaryPanel.this.table.getModel().getValueAt(row, col));
                    if (isCaseInsensitive) {
                        text = text.toLowerCase();
                    }
                    if (!text.contains(this.searchText)) continue;
                    LogSummaryPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                    this.ensureRowIsVisible(row);
                    return;
                }
                if ((row += lineIncrement) < 0) {
                    row = rowCount - 1;
                }
                if (row < rowCount) continue;
                row = 0;
            }
        }

        protected void ensureRowIsVisible(int row) {
            Rectangle line_rect = new Rectangle(LogSummaryPanel.this.table.getCellRect(row, 0, true));
            Rectangle visibleRect = LogSummaryPanel.this.table.getVisibleRect();
            line_rect.width = 99;
            visibleRect.width = 100;
            if (!visibleRect.contains(line_rect)) {
                line_rect.y -= (visibleRect.height - line_rect.height) / 2;
                line_rect.height = visibleRect.height;
                LogSummaryPanel.this.table.scrollRectToVisible(line_rect);
            }
        }
    }
}

