/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.InfoPanelContentProvider;
import com.azul.log.gui.ui.CustomTooltipSupport;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleText;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class InfoPanel
extends JPanel {
    private final Lookup.Result<InfoPanelContentProvider> lookupResult;
    private final JTextPane pane = new JTextPane(){
        final Rectangle bounds = new Rectangle();
        Point lastLocation;
        String lastTooltip;

        @Override
        public JToolTip createToolTip() {
            return CustomTooltipSupport.createTooltip(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            try {
                if (InfoPanel.this.current == null) {
                    return null;
                }
                LogRecord record = InfoPanel.this.current.getRecord();
                if (record == null) {
                    return null;
                }
                AccessibleText accessibleText = this.getAccessibleContext().getAccessibleText();
                Document doc = this.getDocument();
                String text = doc.getText(0, doc.getLength());
                Point point = event.getPoint();
                point.translate(-this.getInsets().left / 2, -this.getInsets().top / 2);
                int char_index = accessibleText.getIndexAtPoint(point);
                if (char_index < 0 || char_index >= text.length()) {
                    return null;
                }
                int start_idx = Math.max(0, text.lastIndexOf(32, char_index) + 1);
                int end_idx = text.indexOf(32, char_index) - 1;
                if (end_idx < 0) {
                    end_idx = text.length() - 1;
                }
                Rectangle first = accessibleText.getCharacterBounds(start_idx);
                Rectangle last = accessibleText.getCharacterBounds(end_idx);
                if (first == null || last == null) {
                    return null;
                }
                Rectangle rect = first.union(last);
                if (!rect.contains(point)) {
                    return null;
                }
                this.bounds.setBounds(rect);
                UIUtils.convertRectToScreen(this.bounds, this);
                return InfoPanel.this.current.getHtmlTooltip(text, char_index);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(InfoPanel.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            String tipText = this.getToolTipText(e);
            if (tipText == null) {
                return null;
            }
            if (!tipText.equals(this.lastTooltip)) {
                this.lastTooltip = tipText;
                JToolTip tip = this.createToolTip();
                tip.setTipText(tipText);
                JPanel tmp = new JPanel(new BorderLayout());
                tmp.add((Component)tip, "Center");
                tmp.doLayout();
                tmp.removeAll();
                Rectangle limitingBounds = UIUtils.shrinkRect(MainFrame.get().getBounds(), MainFrame.get().getInsets());
                Point screenLocation = UIUtils.placeTooltip(limitingBounds, this.bounds, tip.getPreferredSize());
                SwingUtilities.convertPointFromScreen(screenLocation, this);
                this.lastLocation = screenLocation;
            }
            return this.lastLocation;
        }
    };
    private InfoPanelContentProvider.InfoPanelContent current = null;

    public InfoPanel() {
        super(new BorderLayout());
        this.pane.setEditable(false);
        this.pane.setContentType("text/html");
        this.pane.setFont(new Font("Courier New", 0, 13));
        this.pane.setToolTipText("");
        UIUtils.fixCopyPasteActionHotKeys(this.pane);
        JScrollPane scrollPane = new JScrollPane(this.pane);
        ScrollBarUIEx.setup(scrollPane, false);
        this.add((Component)scrollPane, "Center");
        this.lookupResult = Context.lookupResult(InfoPanelContentProvider.class);
        LookupListenerImpl listener = new LookupListenerImpl();
        this.lookupResult.addLookupListener(listener);
        listener.resultChanged(null);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            Collection providers = InfoPanel.this.lookupResult.allInstances();
            for (InfoPanelContentProvider provider : providers) {
                InfoPanelContentProvider.InfoPanelContent content = provider.getInfoPanelContent();
                if (content == null) continue;
                InfoPanel.this.current = content;
                InfoPanel.this.pane.setText("<html>" + content.getAsHtml() + "</html>");
                return;
            }
            InfoPanel.this.pane.setText("");
        }
    }
}

