/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.FavoriteGraphsModel;
import com.azul.log.gui.model.GraphsSelectorModel;
import com.azul.log.gui.ui.SelectionPanel;
import com.azul.log.gui.ui.nodes.GraphNode;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class GraphSelectionPanel
extends SelectionPanel<GraphNode> {
    private final Lookup.Result<LogFilesModel> lookupResult = Context.lookupResult(LogFilesModel.class);
    private LogFilesModel logFilesModel = null;
    private boolean enumerateGraphs = false;

    public GraphSelectionPanel() {
        LookupListenerImpl l = new LookupListenerImpl();
        this.lookupResult.addLookupListener(l);
        l.resultChanged(null);
        FavoriteGraphsModel.getModel().addChangeListener(e -> this.updateModel());
        GraphsSelectorModel.getModel().addChangeListener(e -> this.updateModel());
        ShowEnumerationAction showEnumerationAction = new ShowEnumerationAction(true);
        final ShowEnumerationAction hideEnumerationAction = new ShowEnumerationAction(false);
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 18) {
                    hideEnumerationAction.actionPerformed(null);
                }
            }
        });
        InputMap im = this.tree.getInputMap();
        ActionMap am = this.tree.getActionMap();
        im.put(KeyStroke.getKeyStroke(18, 512, false), "showEnumeration");
        am.put("showEnumeration", showEnumerationAction);
        am.put("hideEnumeration", hideEnumerationAction);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.handleContextMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleContextMenu(mouseEvent);
            }

            private void handleContextMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu contextMenu = new JPopupMenu();
                    contextMenu.add(GraphsSelectorModel.allGraphs);
                    contextMenu.add(GraphsSelectorModel.favoriteGraphs);
                    contextMenu.add(new JSeparator());
                    contextMenu.add(GraphsSelectorModel.enumerateGraphsAction.getMenuPresenter());
                    contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    protected void updateModel() {
        super.updateModel();
        if (this.logFilesModel != null && !this.logFilesModel.getLogFiles().isEmpty()) {
            this.setLookup(this.logFilesModel.getLogFiles().get(0).getLookup());
        }
    }

    public void setActiveLogFile(LogModel logModel) {
        this.setLookup(logModel.lookup(LogFile.class).getLookup());
    }

    private void updateNodes(TreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode n = node.getChildAt(i);
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(n);
            if (n.isLeaf()) continue;
            this.updateNodes(n);
        }
    }

    @Override
    protected boolean renderTags() {
        return GraphsSelectorModel.getModel().isEnumerationEnabled() || this.enumerateGraphs;
    }

    @Override
    protected TreeNode createRootNode() {
        GraphsSelectorModel.Mode activeMode = GraphsSelectorModel.getModel().getActiveMode();
        if (activeMode == null) {
            return new DefaultMutableTreeNode();
        }
        switch (activeMode) {
            case ALL: {
                return this.createAllGraphsRootNode();
            }
            case FAVORITES: {
                return this.createFavoriteGraphsRootNode();
            }
        }
        throw new InternalError();
    }

    @Override
    protected int getRowXOffset(int row, int depth) {
        GraphsSelectorModel.Mode mode = GraphsSelectorModel.getModel().getActiveMode();
        int d = mode == GraphsSelectorModel.Mode.ALL ? 2 : 1;
        int n = mode == GraphsSelectorModel.Mode.ALL ? 10 : 4;
        return depth < d ? -1 : n;
    }

    private TreeNode createFavoriteGraphsRootNode() {
        if (this.logFilesModel == null) {
            return new DefaultMutableTreeNode();
        }
        ArrayList nodes = new ArrayList();
        List<Integer> favoriteGraphs = FavoriteGraphsModel.getModel().getGraphs();
        favoriteGraphs.forEach(id -> {
            List<LogFile> logFiles = this.logFilesModel.getLogFiles();
            for (LogFile logFile : logFiles) {
                PlotData data = logFile.getLookup().lookup(PlotData.class);
                if (data == null) continue;
                String name = data.getGraphNameByID((int)id);
                GraphDefinition definition = data.getGraphDefinitionByID((int)id);
                if (name == null || definition == null) continue;
                nodes.add(new GraphNode(logFile, name, definition, null));
            }
        });
        return new JTree.DynamicUtilTreeNode((Object)"Root", nodes.toArray());
    }

    private TreeNode createAllGraphsRootNode() {
        if (this.logFilesModel == null) {
            return new DefaultMutableTreeNode();
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root", true);
        List<LogFile> logFiles = this.logFilesModel.getLogFiles();
        int categoryNum = 0;
        int graphNum = 0;
        String currentCategory = null;
        DefaultMutableTreeNode categoryNode = null;
        for (LogFile logFile : logFiles) {
            PlotData data = logFile.getLookup().lookup(PlotData.class);
            if (data == null) continue;
            int count = data.getGraphsCount();
            for (int i = 0; i < count; ++i) {
                GraphDefinition gd = data.getGraphDefinition(i);
                String category = data.getGraphCategory(i);
                if (categoryNode == null || !category.equals(currentCategory)) {
                    currentCategory = category;
                    categoryNode = new DefaultMutableTreeNode(category);
                    root.add(categoryNode);
                    ++categoryNum;
                    graphNum = 0;
                }
                GraphNode graphNode = new GraphNode(logFile, data.getGraphName(i), gd, String.format("%d.%d", categoryNum, ++graphNum));
                categoryNode.add(new DefaultMutableTreeNode(graphNode));
            }
        }
        return root;
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            GraphSelectionPanel.this.logFilesModel = Context.lookup(LogFilesModel.class);
            SwingUtilities.invokeLater(GraphSelectionPanel.this::updateModel);
        }
    }

    private class ShowEnumerationAction
    extends AbstractAction {
        private final boolean show;

        public ShowEnumerationAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphSelectionPanel.this.enumerateGraphs = this.show;
            GraphSelectionPanel.this.updateNodes((TreeNode)GraphSelectionPanel.this.tree.getModel().getRoot());
        }
    }
}

