/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.config.api.Config;
import java.awt.Color;
import java.util.Iterator;

public final class ColorPalette {
    private static final Color[] colors_default = new Color[]{Color.decode("#3774A6"), Color.decode("#92AB61"), Color.decode("#AC3E39"), Color.decode("#826B9A"), Color.decode("#47A7B9"), Color.decode("#9EB6D2"), Color.decode("#DF833E"), Color.decode("#D9A09F"), Color.decode("#00A000"), Color.decode("#0ABCC8"), Color.decode("#15EBEB"), Color.decode("#185888"), Color.decode("#28DC8E"), Color.decode("#6B9A82"), Color.decode("#808080"), Color.decode("#AC4B5C"), Color.decode("#D20A3E"), Color.decode("#DCA7A6"), Color.decode("#FF00FF"), Color.decode("#FF7F00"), Color.decode("#7FFF00")};
    private static final Color[] colors_contrast = new Color[]{Color.decode("#808080"), Color.decode("#C0C0C0"), Color.decode("#FF00FF"), Color.decode("#800080"), Color.decode("#FF0000"), Color.decode("#800000"), Color.decode("#808000"), Color.decode("#00FF00"), Color.decode("#008000"), Color.decode("#00FFFF"), Color.decode("#008080"), Color.decode("#0000FF"), Color.decode("#000080")};

    public static Iterator<Color> iterator() {
        return new IteratorImpl();
    }

    public static Color get(int idx) {
        Color[] colors = "contrast".equals(Config.getProperty("palette")) ? colors_contrast : colors_default;
        int i = idx % colors.length;
        Color c = colors[i];
        int mode = idx / colors.length % 3;
        switch (mode) {
            case 0: {
                return c;
            }
            case 1: {
                return c.darker();
            }
            case 2: {
                return c.darker().darker();
            }
        }
        throw new InternalError();
    }

    private static class IteratorImpl
    implements Iterator<Color> {
        private int idx = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Color next() {
            return ColorPalette.get(this.idx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

