/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.VisibleValueRangeModel;
import com.azul.log.gui.utils.UIUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.openide.util.Lookup;

public final class UndoSupport {
    public static final AbstractAction UNDO = new Action("Undo", KeyStroke.getKeyStroke(90, UIUtils.MENU_SHORTCUT_KEY_MASK));
    public static final AbstractAction REDO = new Action("Redo", KeyStroke.getKeyStroke(89, UIUtils.MENU_SHORTCUT_KEY_MASK));
    private static final UndoManager manager = new UndoManager();
    private static boolean inactive = false;
    private static final Lookup.Result<TimeRangeSelectionModel.VisibleTimeRangeModel> vtlLookupResult;
    private static final Lookup.Result<JFreeChart> jfcLookupResult;
    private static final Lookup.Result<MarksModel> mmLookupResult;
    private static TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeModel;
    private static PlotChangeListenerImpl plotChangeListenerImpl;

    public static JMenuItem getMenuPresenter(AbstractAction action) {
        JMenuItem item = new JMenuItem(action);
        if (action instanceof Action) {
            item.setAccelerator(((Action)action).ks);
        }
        return item;
    }

    private UndoSupport() {
    }

    private static void updateActions() {
        UNDO.setEnabled(manager.canUndo());
        UNDO.putValue("Name", manager.getUndoPresentationName());
        REDO.setEnabled(manager.canRedo());
        REDO.putValue("Name", manager.getRedoPresentationName());
    }

    static {
        visibleTimeModel = null;
        plotChangeListenerImpl = null;
        vtlLookupResult = Context.lookupResult(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        vtlLookupResult.addLookupListener(le -> {
            visibleTimeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
            UndoSupport.updateActions();
        });
        jfcLookupResult = Context.lookupResult(JFreeChart.class);
        jfcLookupResult.addLookupListener(le -> {
            JFreeChart chart = Context.lookup(JFreeChart.class);
            if (chart != null) {
                XYPlot plot = chart.getXYPlot();
                plotChangeListenerImpl = new PlotChangeListenerImpl(plot);
                plot.addChangeListener(plotChangeListenerImpl);
            }
            UndoSupport.updateActions();
        });
        mmLookupResult = Context.lookupResult(MarksModel.class);
        mmLookupResult.addLookupListener(le -> {
            MarksModel model = Context.lookup(MarksModel.class);
            if (model != null) {
                model.addUndoableEditListener(e -> {
                    manager.addEdit(e.getEdit());
                    UndoSupport.updateActions();
                });
            }
            UndoSupport.updateActions();
        });
    }

    private static class ZoomAction
    extends AbstractUndoableEdit {
        private final Range oldXRange;
        private final Range oldYRange;
        private final Range newXRange;
        private final Range newYRange;
        private final int graphID;

        private ZoomAction(int graphID, Range oldXRange, Range oldYRange, Range newXRange, Range newYRange) {
            this.graphID = graphID;
            this.oldXRange = oldXRange;
            this.oldYRange = oldYRange;
            this.newXRange = newXRange;
            this.newYRange = newYRange;
        }

        @Override
        public String getPresentationName() {
            return "Zoom";
        }

        @Override
        public boolean canRedo() {
            JFreeChart chart = Context.lookup(JFreeChart.class);
            return chart != null && super.canRedo();
        }

        @Override
        public boolean canUndo() {
            JFreeChart chart = Context.lookup(JFreeChart.class);
            return chart != null && super.canUndo();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.setRanges(this.oldXRange, this.oldYRange);
            plotChangeListenerImpl.oldXRange = this.oldXRange;
            if (this.sameGraph()) {
                plotChangeListenerImpl.oldYRange = this.oldYRange;
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.setRanges(this.newXRange, this.newYRange);
            plotChangeListenerImpl.oldXRange = this.newXRange;
            if (this.sameGraph()) {
                plotChangeListenerImpl.oldYRange = this.newYRange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRanges(Range xrange, Range yrange) {
            inactive = true;
            try {
                JFreeChart chart = Context.lookup(JFreeChart.class);
                XYPlot plot = chart.getXYPlot();
                plot.getDomainAxis().setRange(xrange);
                if (this.sameGraph()) {
                    plot.getRangeAxis().setRange(yrange);
                } else {
                    VisibleValueRangeModel rangeModel = Context.lookup(VisibleValueRangeModel.class);
                    rangeModel.setVisibleValueRange(this.graphID, yrange);
                }
            }
            finally {
                inactive = false;
            }
        }

        private boolean sameGraph() {
            GraphDefinition gd = Context.lookup(GraphDefinition.class);
            return gd != null && gd.getID() == this.graphID;
        }
    }

    static class PlotChangeListenerImpl
    implements PlotChangeListener {
        private final int graphID;
        private final XYPlot plot;
        private Range oldXRange;
        private Range oldYRange;

        public PlotChangeListenerImpl(XYPlot plot) {
            this.plot = plot;
            GraphDefinition gd = Context.lookup(GraphDefinition.class);
            this.graphID = gd == null ? -1 : gd.getID();
            this.oldXRange = plot.getDomainAxis().getRange();
            this.oldYRange = plot.getRangeAxis().getRange();
        }

        @Override
        public void plotChanged(PlotChangeEvent event) {
            if (!(inactive || visibleTimeModel != null && visibleTimeModel.isAdjusting())) {
                Range newXRange = this.plot.getDomainAxis().getRange();
                Range newYRange = this.plot.getRangeAxis().getRange();
                if (!newXRange.equals(this.oldXRange) || !newYRange.equals(this.oldYRange)) {
                    manager.addEdit(new ZoomAction(this.graphID, this.oldXRange, this.oldYRange, newXRange, newYRange));
                    UndoSupport.updateActions();
                    this.oldXRange = newXRange;
                    this.oldYRange = newYRange;
                }
            }
        }
    }

    private static final class Action
    extends AbstractAction {
        private final KeyStroke ks;

        private Action(String name, KeyStroke ks) {
            super(name);
            this.ks = ks;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this == UNDO) {
                manager.undo();
            } else {
                manager.redo();
            }
            UndoSupport.updateActions();
        }
    }
}

