/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.gui.model.ParserExceptionsModel;
import com.azul.log.gui.model.support.FilesContentProvider;
import com.azul.log.gui.support.LogFilesSupport;
import com.azul.log.gui.support.UIInteractionHandler;
import com.azul.log.gui.ui.ProgressBar;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.api.LogParser;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.spi.LogStreamHandler;
import com.azul.log.utils.ProgressModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public final class OpenFileSupport {
    private OpenFileSupport() {
    }

    public static void open(final List<File> files, final LogFilesOpenHandler consumer) {
        final AtomicReference progressBarRef = new AtomicReference();
        SwingWorker<List<LogFile>, Void> worker = new SwingWorker<List<LogFile>, Void>(){

            @Override
            protected List<LogFile> doInBackground() throws Exception {
                ArrayList<LogFile> logFiles = new ArrayList<LogFile>();
                for (File file : files) {
                    ProgressBar progressBar = ProgressBar.create("Extracting data from");
                    progressBarRef.set(progressBar);
                    SwingUtilities.invokeAndWait(() -> progressBar.setNote(file.getName()));
                    LogFile logFile = OpenFileSupport.parseFile(file, progressBar.getProgressModel());
                    if (logFile.lookup(LogModel.class) != null) {
                        logFiles.add(logFile);
                    }
                    progressBar.close();
                }
                return logFiles;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                String error = null;
                List logFiles = null;
                try (ProgressBar progressBar = (ProgressBar)progressBarRef.get();){
                    logFiles = (List)this.get();
                }
                consumer.accept(logFiles, error);
            }
        };
        worker.execute();
    }

    private static LogFile parseFile(File file, ProgressModel progress) throws IOException {
        LogParser parser = LogParser.getParserFor(file.toPath(), new UIInteractionHandler());
        if (parser == null) {
            throw new ParserException("Unable to detect file format for " + file);
        }
        List<Path> paths = parser.getModel().getPaths();
        LogStreamHandlerImpl streamHandler = new LogStreamHandlerImpl(paths);
        ParserExceptionsModel exceptions = ParserExceptionsModel.getModel();
        exceptions.clear();
        parser.addStreamHandler(streamHandler);
        parser.addParserExceptionHandler(ex -> {
            exceptions.addException(ex);
            return true;
        });
        LogFile logFile = parser.parse(progress);
        logFile.getInstanceContext().add(FilesContentProvider.create(streamHandler.getLogFilesMappingInfo()));
        return logFile;
    }

    private static class LogStreamHandlerImpl
    implements LogStreamHandler {
        private final LogFilesSupport.LogFilesMappingInfo filesMappingInfo;
        private int currentFileIdx;
        private long currentFileMinOffset;
        private long currentFileMaxOffset;
        private long offset;

        public LogStreamHandlerImpl(List<Path> files) throws IOException {
            this.filesMappingInfo = new LogFilesSupport.LogFilesMappingInfo(files);
            this.currentFileIdx = 0;
            this.currentFileMinOffset = 0L;
            this.currentFileMaxOffset = Files.size(files.get(this.currentFileIdx));
        }

        @Override
        public boolean processLine(int lineNumber, String line) throws Exception {
            if (this.currentFileIdx >= this.filesMappingInfo.getPaths().size()) {
                return false;
            }
            this.filesMappingInfo.addLineOffset(this.currentFileIdx, this.offset - this.currentFileMinOffset);
            int lineLength = line.getBytes().length;
            this.filesMappingInfo.updateMaxLineLength(lineNumber, lineLength);
            this.offset += (long)(lineLength + 1);
            if (this.offset >= this.currentFileMaxOffset) {
                if (++this.currentFileIdx >= this.filesMappingInfo.getPaths().size()) {
                    return false;
                }
                this.filesMappingInfo.setFirstLineNumber(this.currentFileIdx, lineNumber);
                this.currentFileMinOffset = this.currentFileMaxOffset;
                this.currentFileMaxOffset += Files.size(this.filesMappingInfo.getPaths().get(this.currentFileIdx));
            }
            return true;
        }

        LogFilesSupport.LogFilesMappingInfo getLogFilesMappingInfo() {
            return this.filesMappingInfo;
        }
    }

    @FunctionalInterface
    public static interface LogFilesOpenHandler
    extends BiConsumer<List<LogFile>, String> {
    }
}

