/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.ProgressBar;
import com.azul.log.utils.CommonUtils;
import com.azul.log.utils.ProgressModel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public final class DownloadSupport {
    private DownloadSupport() {
    }

    public static void download(URI uri, Consumer<File> consumer) throws IOException {
        new DownloadWorker(uri, consumer).execute();
    }

    private static final class DownloadWorker
    extends SwingWorker<File, Void> {
        private final URI uri;
        private final ProgressBar progressBar;
        private final ProgressModel progressModel;
        private final Path path;
        private final Consumer<File> consumer;

        public DownloadWorker(URI uri, Consumer<File> consumer) throws IOException {
            this.uri = uri;
            this.path = CommonUtils.createTempFileForURI(uri);
            this.progressBar = ProgressBar.create("Downloading ... ");
            this.progressModel = this.progressBar.getProgressModel();
            this.consumer = consumer;
        }

        @Override
        protected File doInBackground() {
            try {
                return CommonUtils.downloadFile(this.uri, this.path, this.progressModel).toFile();
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainFrame.get(), "Download failed: " + ex.getMessage(), "Error", 0));
                return null;
            }
        }

        @Override
        protected void done() {
            this.progressBar.close();
            if (!this.progressModel.isCanceled()) {
                try {
                    File file = (File)this.get();
                    if (file != null && file.exists()) {
                        file.getParentFile().deleteOnExit();
                        file.deleteOnExit();
                        this.consumer.accept(file);
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(DownloadSupport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

