/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.search;

import com.azul.log.gui.model.spi.LogContentProvider;
import com.azul.log.gui.search.SearchProgressListener;
import com.azul.log.gui.search.SearchTaskContinuation;
import com.azul.log.parser.utils.TextUtils;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public final class LogTextSearchTask {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final SearchWorker worker;

    private LogTextSearchTask(LogContentProvider contentProvider, String searchString, int startLine, SearchDirection direction, boolean isCaseSensitive, SearchProgressListener progressListener, SearchTaskContinuation continuation) {
        this.worker = new SearchWorker(contentProvider, searchString, startLine, direction, isCaseSensitive, progressListener, continuation);
        if (progressListener != null) {
            progressListener.startProgress(contentProvider.getLinesCount());
        }
        this.worker.execute();
    }

    public static LogTextSearchTask submit(LogContentProvider contentProvider, String text, int startLine, SearchDirection direction, boolean isCaseSensitive, SearchProgressListener progressListener, SearchTaskContinuation continuation) {
        return new LogTextSearchTask(contentProvider, text, startLine, direction, isCaseSensitive, progressListener, continuation);
    }

    public void cancel() {
        this.worker.cancel();
    }

    private static final class ProgressTracker {
        private final SearchProgressListener listener;
        private final AtomicInteger progress = new AtomicInteger(0);

        public ProgressTracker(SearchProgressListener listener) {
            this.listener = listener;
        }

        public void setProgress(int value) {
            if (this.listener != null) {
                int current;
                while ((current = this.progress.get()) < value) {
                    if (!this.progress.compareAndSet(current, value)) continue;
                    this.listener.setProgress(value);
                    break;
                }
            }
        }
    }

    private static final class SearchUsingContentProvider
    extends SearchAlgorithm {
        public SearchUsingContentProvider(LogContentProvider contentProvider, String searchString, int startLine, SearchDirection direction, boolean isCaseSensitive, AtomicBoolean interrupt, ProgressTracker tracker) {
            super(contentProvider, searchString, startLine, direction, isCaseSensitive, interrupt, tracker);
        }

        @Override
        protected int start() {
            int linesCount = this.contentProvider.getLinesCount();
            int lineIncrement = this.direction == SearchDirection.FORWARD ? 1 : -1;
            int line = this.startLine + lineIncrement;
            while (!this.interrupted.get() && line != this.startLine) {
                CharSequence lineContent;
                if ((this.progress++ & 0x3FFF) == 0) {
                    this.tracker.setProgress(this.progress);
                }
                if ((lineContent = this.contentProvider.getLine(line)) == null) {
                    if (!Thread.interrupted()) continue;
                    this.interrupted.set(true);
                    continue;
                }
                if (this.isCaseSensitive ? lineContent.toString().contains(this.searchString) : TextUtils.findIgnoreCase(lineContent.toString(), this.searchString, this.searchStringLength)) {
                    return line;
                }
                if ((line += lineIncrement) < 1) {
                    line = linesCount;
                }
                if (line > linesCount) {
                    line = 1;
                }
                if (!Thread.interrupted()) continue;
                this.interrupted.set(true);
            }
            return -1;
        }
    }

    private static abstract class SearchAlgorithm
    implements Callable<Integer> {
        protected final SearchDirection direction;
        protected final AtomicBoolean interrupted;
        protected final int startLine;
        protected final LogContentProvider contentProvider;
        protected final boolean isCaseSensitive;
        protected final String searchString;
        protected final int searchStringLength;
        protected final ProgressTracker tracker;
        protected int progress;

        protected SearchAlgorithm(LogContentProvider contentProvider, String searchString, int startLine, SearchDirection direction, boolean isCaseSensitive, AtomicBoolean interrupt, ProgressTracker tracker) {
            this.contentProvider = contentProvider;
            this.searchString = searchString;
            this.direction = direction;
            this.startLine = startLine;
            this.isCaseSensitive = isCaseSensitive;
            this.interrupted = interrupt;
            this.tracker = tracker;
            this.progress = 0;
            this.searchStringLength = searchString.length();
        }

        @Override
        public Integer call() {
            long start_time = System.currentTimeMillis();
            int result = this.start();
            long end_time = System.currentTimeMillis();
            if (Thread.interrupted()) {
                this.interrupted.set(true);
            }
            Logger.getLogger(SearchAlgorithm.class.getName()).fine(String.format("%s: Search completed in %d ms. [interrupted: %b]", this.getClass().getSimpleName(), end_time - start_time, this.interrupted.get()));
            return result;
        }

        protected abstract int start();
    }

    private static final class SearchWorker
    extends SwingWorker<Integer, String> {
        private final LogContentProvider contentProvider;
        private final int startLine;
        private final String searchString;
        private final SearchDirection direction;
        private final boolean isCaseSensitive;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean interrupt = new AtomicBoolean(false);
        private final SearchProgressListener progressListener;
        private final SearchTaskContinuation continuation;

        private SearchWorker(LogContentProvider contentProvider, String searchString, int startLine, SearchDirection direction, boolean isCaseSensitive, SearchProgressListener progressListener, SearchTaskContinuation continuation) {
            this.contentProvider = contentProvider;
            this.startLine = startLine;
            this.searchString = searchString;
            this.direction = direction;
            this.isCaseSensitive = isCaseSensitive;
            this.progressListener = progressListener;
            this.continuation = continuation;
        }

        public void cancel() {
            this.cancelled.set(true);
            this.interrupt.set(true);
        }

        @Override
        protected Integer doInBackground() throws Exception {
            ProgressTracker tracker = new ProgressTracker(this.progressListener);
            String text = this.isCaseSensitive ? this.searchString : this.searchString.toUpperCase();
            SearchUsingContentProvider algorithm1 = new SearchUsingContentProvider(this.contentProvider, text, this.startLine, this.direction, this.isCaseSensitive, this.interrupt, tracker);
            Integer line = (Integer)executor.invokeAny(Collections.singletonList(algorithm1));
            this.interrupt.set(true);
            return line;
        }

        @Override
        protected void done() {
            if (this.progressListener != null) {
                this.progressListener.stopProgress();
            }
            if (this.continuation != null && !this.cancelled.get()) {
                try {
                    this.continuation.lineFound((Integer)this.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
    }

    public static enum SearchDirection {
        FORWARD,
        BACKWARD;

    }
}

