/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model.support;

import com.azul.log.gui.model.LogLineOffsetMap;
import com.azul.log.gui.model.api.LogLocation;
import com.azul.log.gui.model.spi.LogContentProvider;
import com.azul.log.gui.support.LogFilesSupport;
import com.azul.log.parser.spi.Destroyable;
import com.azul.log.parser.utils.Cache;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public final class FilesContentProvider
implements LogContentProvider,
Destroyable {
    private static final long TIMEOUT_MS = 3L;
    private final Cache<Integer, CharSequence> cache;
    private final LogFilesSupport.LogFilesMappingInfo mappingInfo;
    private final FileBuffer[] buffers;
    private final LineFetchingThread fetchingThread = new LineFetchingThread();

    private FilesContentProvider(LogFilesSupport.LogFilesMappingInfo mappingInfo) throws IOException {
        this.cache = Cache.create("CachedLogContentProvider");
        this.mappingInfo = mappingInfo;
        List<Path> paths = mappingInfo.getPaths();
        this.buffers = new FileBuffer[paths.size()];
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new FileBuffer(paths.get(i));
        }
    }

    public static LogContentProvider create(LogFilesSupport.LogFilesMappingInfo info) throws IOException {
        FilesContentProvider provider = new FilesContentProvider(info);
        provider.fetchingThread.start();
        return provider;
    }

    @Override
    public int getWidestLineNumber() {
        return this.mappingInfo.getMaxLengthLineNumber();
    }

    @Override
    public int getLinesCount() {
        return this.mappingInfo.getLinesCount();
    }

    @Override
    public CharSequence getLine(int lineNumber) {
        return this.readLine(lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getLine(int lineNumber, Consumer<CharSequence> delayedLineConsumer) {
        CharSequence line = this.cache.get(lineNumber);
        if (line == null) {
            LineFetchRequest request;
            LineFetchRequest lineFetchRequest = request = new LineFetchRequest(() -> this.readLine(lineNumber));
            synchronized (lineFetchRequest) {
                this.fetchingThread.submitRequest(request);
                try {
                    request.wait(3L);
                    line = request.line;
                    if (line == null) {
                        request.consumer = delayedLineConsumer;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            }
        }
        return line;
    }

    @Override
    public void destroy() {
        this.fetchingThread.terminate();
        this.cache.destroy();
        Arrays.fill(this.buffers, null);
    }

    private CharSequence readLine(int lineNumber) {
        try {
            LogLineOffsetMap.FileOffset offset = this.mappingInfo.getFileOffset(lineNumber);
            CharSequence cs = this.buffers[offset.getFileIndex()].readLine(offset.getOffsetInFile());
            this.cache.put(lineNumber, cs);
            return cs;
        }
        catch (ClosedByInterruptException offset) {
        }
        catch (IOException ex) {
            Logger.getLogger(FilesContentProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public LogLocation getLogLocation(int lineNumber) {
        return this.mappingInfo.getLogLocation(lineNumber);
    }

    private static class FileBuffer {
        private static final int BUFFER_SIZE = 32768;
        private final Path path;
        private final long fileSize;
        private final ByteBuffer buffer;
        private long bufferedStart;
        private long bufferedEnd;

        public FileBuffer(Path path) throws IOException {
            this.path = path;
            this.fileSize = Files.size(path);
            this.buffer = ByteBuffer.allocateDirect(32768);
            this.bufferedEnd = 0L;
            this.bufferedStart = 0L;
        }

        private synchronized CharSequence readLine(long offset) throws IOException {
            if (offset < this.bufferedStart || offset >= this.bufferedEnd) {
                this.bufferedStart = offset & 0xFFFFFFFFFFFFE000L;
                ((Buffer)this.buffer).rewind();
                try (FileChannel channel = FileChannel.open(this.path, StandardOpenOption.READ);){
                    this.bufferedEnd = this.bufferedStart + (long)channel.read(this.buffer, this.bufferedStart);
                }
            }
            StringBuilder sb = new StringBuilder();
            ((Buffer)this.buffer).position((int)(offset - this.bufferedStart));
            int b = 10;
            while (this.buffer.hasRemaining()) {
                byte by = this.buffer.get();
                b = by;
                if (by == 10) break;
                sb.append((char)b);
            }
            if (!this.buffer.hasRemaining() && b != 10 && this.bufferedEnd < this.fileSize && this.bufferedStart != (offset & 0xFFFFFFFFFFFFE000L)) {
                this.bufferedEnd = 0L;
                this.bufferedStart = 0L;
                return this.readLine(offset);
            }
            return sb.toString();
        }
    }

    private static final class LineFetchingThread
    extends Thread {
        private static final int RING_BUFFER_SIZE = 300;
        private final Lock lock = new ReentrantLock();
        private final Condition request_added = this.lock.newCondition();
        private final LineFetchRequest[] ring_buffer;
        private final AtomicBoolean terminated = new AtomicBoolean(false);
        private int requests_count;
        private int current_idx;

        private LineFetchingThread() {
            this.setName("LineFetchingThread");
            this.setDaemon(true);
            this.ring_buffer = new LineFetchRequest[300];
            this.current_idx = 0;
            this.requests_count = 0;
        }

        public void submitRequest(LineFetchRequest request) {
            this.lock.lock();
            try {
                this.ring_buffer[this.current_idx] = request;
                this.current_idx = (this.current_idx + 1) % 300;
                this.requests_count = Math.min(this.requests_count + 1, 300);
                this.request_added.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.terminated.get()) {
                LineFetchRequest request;
                this.lock.lock();
                try {
                    while (this.requests_count == 0) {
                        try {
                            this.request_added.await();
                        }
                        catch (InterruptedException ex) {
                            Thread.interrupted();
                            this.lock.unlock();
                            return;
                        }
                    }
                    --this.requests_count;
                    this.current_idx = (300 + this.current_idx - 1) % 300;
                    request = this.ring_buffer[this.current_idx];
                }
                finally {
                    this.lock.unlock();
                }
                request.line = (CharSequence)request.reader.get();
                LineFetchRequest lineFetchRequest = request;
                synchronized (lineFetchRequest) {
                    request.notify();
                }
                lineFetchRequest = request;
                synchronized (lineFetchRequest) {
                    if (request.consumer != null) {
                        SwingUtilities.invokeLater(() -> request.consumer.accept(request.line));
                    }
                }
            }
        }

        public void terminate() {
            this.terminated.set(true);
            this.interrupt();
        }
    }

    private static final class LineFetchRequest {
        private final Supplier<CharSequence> reader;
        private CharSequence line;
        private Consumer<CharSequence> consumer;

        public LineFetchRequest(Supplier<CharSequence> reader) {
            this.reader = reader;
        }
    }
}

