/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model.api;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.model.PersistentModel;
import com.azul.log.utils.CommonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class PersistentDistinctValuesModel
implements PersistentModel {
    private static final Map<String, PersistentDistinctValuesModel> models = new HashMap<String, PersistentDistinctValuesModel>();
    private final List<String> labels = new ArrayList<String>();
    private final Map<String, Integer> sorted = new TreeMap<String, Integer>();
    private final String id;

    private PersistentDistinctValuesModel(String id) {
        this.id = id;
    }

    public static synchronized PersistentDistinctValuesModel getModel(String id) {
        PersistentDistinctValuesModel model = models.get(id = Integer.toHexString(id.hashCode()));
        if (model == null) {
            model = new PersistentDistinctValuesModel(id);
            models.put(id, model);
            PersistentDistinctValuesModel.init(model);
        }
        return model;
    }

    private static void init(PersistentDistinctValuesModel model) {
        model.initFromExternalString(Config.getProperty(model.getPersistentID()));
    }

    @Override
    public String getPersistentID() {
        return "DV_" + this.id;
    }

    @Override
    public void initFromExternalString(String data) {
        if (data != null) {
            byte[] bytes = CommonUtils.decodeBase64(data);
            try {
                BufferedReader is = new BufferedReader(new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(bytes))));
                Object object = null;
                try {
                    this.labels.addAll(Arrays.asList(is.readLine().split(";")));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PersistentDistinctValuesModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            int idx = 0;
            for (String label : this.labels) {
                this.sorted.put(label, idx++);
            }
        }
    }

    @Override
    public String toExternalString() {
        StringBuilder sb = new StringBuilder();
        for (String label : this.labels) {
            sb.append(label).append(';');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        try (GZIPOutputStream os = new GZIPOutputStream(bb);){
            os.write(sb.toString().getBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(PersistentDistinctValuesModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return CommonUtils.encodeBase64(bb.toByteArray());
    }

    public Integer getValueIndex(String label) {
        Integer index = this.sorted.get(label);
        if (index == null) {
            index = this.labels.size();
            this.sorted.put(label, index);
            this.labels.add(label);
            Config.setProperty(this.getPersistentID(), this.toExternalString());
        }
        return index;
    }
}

