/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.model.api.RelativeTimestamp;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class TimeRange {
    private final RelativeTimestamp start;
    private final RelativeTimestamp end;

    public TimeRange(RelativeTimestamp start, RelativeTimestamp end) {
        this.start = start;
        this.end = end;
    }

    public TimeRange(long start, long end, TimeUnit units) {
        this.start = RelativeTimestamp.of((double)start, units);
        this.end = RelativeTimestamp.of((double)end, units);
    }

    public long length(TimeUnit timeUnit) {
        return (long)RelativeTimestamp.delta(this.end, this.start, timeUnit);
    }

    public RelativeTimestamp getStart() {
        return this.start;
    }

    public RelativeTimestamp getEnd() {
        return this.end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimeRange) {
            TimeRange that = (TimeRange)obj;
            boolean start_ok = Objects.equals(this.start, that.start);
            boolean end_ok = Objects.equals(this.end, that.end);
            return start_ok && end_ok;
        }
        return false;
    }

    public String toString() {
        return "[" + this.start + " - " + this.end + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 71 * hash + (this.end != null ? this.end.hashCode() : 0);
        return hash;
    }
}

