/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.spi.InfoPanelContentProvider;
import com.azul.log.gui.model.spi.LogRecordProvider;
import com.azul.log.gui.model.spi.PhasesInfoProvider;
import com.azul.log.gui.support.SimpleRecordInfoPanelContent;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;

public class LogRecordElement
extends UIElement
implements LogRecordProvider,
InfoPanelContentProvider,
PhasesInfoProvider {
    protected final LogRecord record;

    public LogRecordElement(LogRecord record, LogModel logModel) {
        super(record.getEventRawRelativeTimestamp(), record.getLogLineNumber(), logModel);
        this.record = record;
    }

    @Override
    public final LogRecord getLogRecord() {
        return this.record;
    }

    @Override
    public LogRecord.PhaseInfoList getPhases() {
        return this.record.getEventPhases();
    }

    @Override
    public InfoPanelContentProvider.InfoPanelContent getInfoPanelContent() {
        return new SimpleRecordInfoPanelContent(this.record, this.getLogLineContent().trim());
    }
}

