/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FavoriteGraphsModel
extends AbstractModel
implements PersistentModel {
    private static final FavoriteGraphsModel model = new FavoriteGraphsModel();
    private final List<Integer> ids = new ArrayList<Integer>();

    private FavoriteGraphsModel() {
    }

    public static FavoriteGraphsModel getModel() {
        return model;
    }

    public synchronized List<Integer> getGraphs() {
        return Collections.unmodifiableList(this.ids);
    }

    public synchronized void add(int id) {
        if (!this.ids.contains(id)) {
            this.ids.add(id);
            this.fireChange();
        }
    }

    public synchronized void remove(int id) {
        int idx = this.ids.indexOf(id);
        if (idx >= 0) {
            this.ids.remove(idx);
            this.fireChange();
        }
    }

    public boolean contains(int id) {
        return this.ids.contains(id);
    }

    @Override
    public String getPersistentID() {
        return "FavoriteGraphs";
    }

    @Override
    public synchronized String toExternalString() {
        StringBuilder sb = new StringBuilder();
        this.ids.stream().map(Integer::toHexString).forEach(id -> sb.append((String)id).append(' '));
        return sb.toString();
    }

    @Override
    public synchronized void initFromExternalString(String str) {
        this.ids.clear();
        if (str != null) {
            Arrays.stream(str.split(" ")).filter(CommonUtils.not(String::isEmpty)).map(id -> (int)Long.parseLong(id, 16)).forEach(this.ids::add);
        }
        this.fireChange();
    }
}

