/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import java.io.PrintStream;
import java.util.Collection;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class Context {
    private static final boolean TRACE_CONTEXT = Boolean.getBoolean("TraceContext");
    private static final ProxyLookup.Controller controller = new ProxyLookup.Controller();
    private static final ProxyLookup lookup = new ProxyLookup(controller);
    private static final Lookup.Result<Object> lookupResult;

    private Context() {
    }

    public static void setContext(Lookup lookup) {
        controller.setLookups(lookup);
    }

    private static void dumpLookupContent() {
        PrintStream out = System.out;
        out.println("Global Lookup:");
        lookupResult.allInstances().forEach(obj -> out.append("  ").println(obj.toString()));
        out.println("--------------");
    }

    public static <T> T lookup(Class<T> klass) {
        return lookup.lookup(klass);
    }

    public static <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return lookup.lookup(template);
    }

    public static <T> Collection<? extends T> lookupAll(Class<T> klass) {
        return lookup.lookupAll(klass);
    }

    public static <T> Lookup.Result<T> lookupResult(Class<T> klass) {
        return lookup.lookupResult(klass);
    }

    static {
        if (TRACE_CONTEXT) {
            lookupResult = lookup.lookupResult(Object.class);
            lookupResult.addLookupListener(e -> Context.dumpLookupContent());
            Context.dumpLookupContent();
        } else {
            lookupResult = null;
        }
    }
}

