/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.marks;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.gui.ui.Markline;
import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogMarkRecord;
import com.azul.log.model.api.LogModel;
import com.azul.log.utils.CommonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public final class MarksModel
extends AbstractModel {
    static final SortedSet<Mark> EMPTY = Collections.unmodifiableSortedSet(new TreeSet());
    private static final ScheduledExecutorService exec = Executors.newScheduledThreadPool(1);
    private final MarksCategoryModel categoriesModel = new MarksCategoryModel();
    private final Map<String, SortedSet<Mark>> marks = new HashMap<String, SortedSet<Mark>>();
    private final SortedSet<Mark> allMarks = new TreeSet<Mark>((m1, m2) -> m2.getTimestamp().compareTo(m1.getTimestamp()));
    private final HashMap<Integer, Mark> lineToMarkMap = new HashMap();
    private final UndoableEditSupport undoableEditSupport = new UndoableEditSupport();
    private final Set<String> storeIds = new HashSet<String>();
    private ScheduledFuture<?> task;

    private MarksModel() {
    }

    public static MarksModel create(Collection<LogFile> logFiles) {
        Markline.AttributesProvider.reset();
        MarksModel model = new MarksModel();
        for (LogFile logFile : logFiles) {
            LogModel logModel = logFile.lookup(LogModel.class);
            if (logModel == null) continue;
            logModel.getRecordsMap().forEach((klass, records) -> {
                if (LogMarkRecord.class.isAssignableFrom((Class<?>)klass)) {
                    records.forEach(r -> {
                        try {
                            LogMarkRecord record = (LogMarkRecord)r;
                            model.addMarkSilently(Mark.create(record.getLogRelativeTimestamp(), record.getLogLineNumber(), record.category, record.label, false, logModel));
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(MarksModel.class.getName()).log(Level.WARNING, ex.getMessage());
                        }
                    });
                }
            });
            Path savedUserMarksFile = MarksModel.getStoragePath(logModel.getLogUID());
            if (!Files.isReadable(savedUserMarksFile)) continue;
            try {
                BufferedReader br = Files.newBufferedReader(savedUserMarksFile, Charset.defaultCharset());
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        try {
                            model.addMarkSilently(Mark.fromExternalString(logModel, line));
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(MarksModel.class.getName()).log(Level.WARNING, ex.getMessage());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MarksModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return model;
    }

    private static Path getStoragePath(String storageId) {
        Path storageRootPath = Config.getConfigDir().resolve("marks");
        if (!Files.exists(storageRootPath, new LinkOption[0])) {
            try {
                Files.createDirectories(storageRootPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Logger.getLogger(MarksModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return storageRootPath.resolve(storageId);
    }

    public static synchronized void fireModelChange() {
        MarksModel model = Context.lookup(MarksModel.class);
        if (model != null) {
            model.fireModelChangeImpl();
        }
    }

    public synchronized SortedSet<Mark> getMarks() {
        return Collections.unmodifiableSortedSet(this.allMarks);
    }

    public synchronized SortedSet<Mark> getMarks(String category) {
        SortedSet<Mark> res = this.marks.get(category);
        return res == null ? EMPTY : Collections.unmodifiableSortedSet(res);
    }

    public synchronized void addMark(final Mark mark) {
        this.addMarkSilently(mark);
        this.fireModelChangeImpl();
        this.undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return "Add Mark";
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                MarksModel.this.removeMarkSilently(mark);
                MarksModel.this.fireModelChangeImpl();
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                MarksModel.this.addMarkSilently(mark);
                MarksModel.this.fireModelChangeImpl();
            }
        });
    }

    private synchronized void addMarkSilently(Mark mark) {
        this.allMarks.add(mark);
        this.storeIds.add(mark.getStoreId());
        String category = mark.getCategory();
        this.marks.computeIfAbsent(category, c -> {
            this.categoriesModel.addCategory(category);
            return new TreeSet<Mark>(Comparator.comparingLong(UIElement::getLogLineNumber));
        }).add(mark);
        this.lineToMarkMap.put(mark.getLogLineNumber(), mark);
    }

    public synchronized void removeMark(final Mark mark) {
        this.removeMarkSilently(mark);
        this.fireModelChangeImpl();
        this.undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return "Remove Mark";
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                MarksModel.this.addMarkSilently(mark);
                MarksModel.this.fireModelChangeImpl();
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                MarksModel.this.removeMarkSilently(mark);
                MarksModel.this.fireModelChangeImpl();
            }
        });
    }

    public synchronized void removeMarkSilently(Mark mark) {
        this.allMarks.remove(mark);
        String category = mark.getCategory();
        SortedSet<Mark> list = this.marks.get(category);
        if (list != null && list.remove(mark)) {
            this.lineToMarkMap.remove(mark.getLogLineNumber());
            if (list.isEmpty()) {
                this.marks.remove(category);
                this.categoriesModel.removeCategory(category);
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditSupport.addUndoableEditListener(listener);
    }

    public synchronized MarksCategoryModel getCategoriesModel() {
        return this.categoriesModel;
    }

    private void fireModelChangeImpl() {
        this.fireChange();
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.task = exec.schedule(() -> {
            MarksModel marksModel = this;
            synchronized (marksModel) {
                Map<String, List<Mark>> userMarks = this.allMarks.stream().filter(Mark::isUserMark).collect(Collectors.groupingBy(Mark::getStoreId));
                Set<String> storeIdsToSave = userMarks.keySet();
                Set<String> storeIdsToRemove = this.storeIds.stream().filter(CommonUtils.not(storeIdsToSave::contains)).collect(Collectors.toSet());
                userMarks.forEach((storeId, marks) -> {
                    try (BufferedWriter bw = Files.newBufferedWriter(MarksModel.getStoragePath(storeId), Charset.defaultCharset(), new OpenOption[0]);){
                        for (Mark mark : marks) {
                            bw.write(mark.toExternalString());
                            bw.newLine();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MarksModel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                storeIdsToRemove.forEach(storeId -> {
                    try {
                        Path storagePath = MarksModel.getStoragePath(storeId);
                        if (Files.exists(storagePath, new LinkOption[0])) {
                            Files.delete(storagePath);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MarksModel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public Mark getMarkAtLogLine(int line) {
        return this.lineToMarkMap.get(line);
    }

    public static final class MarksCategoryModel
    extends AbstractModel {
        private final Set<String> visibleCategories = new HashSet<String>();
        private final Set<String> allCategories = new HashSet<String>();

        private MarksCategoryModel() {
        }

        private synchronized void addCategory(String category) {
            this.allCategories.add(category);
            if (this.visibleCategories.add(category)) {
                this.fireChange();
            }
        }

        private synchronized void removeCategory(String category) {
            this.visibleCategories.remove(category);
            if (this.allCategories.remove(category)) {
                this.fireChange();
            }
        }

        public synchronized boolean isVisible(String category) {
            return this.visibleCategories.contains(category);
        }

        public synchronized Set<String> getVisibleCategories() {
            return Collections.unmodifiableSet(this.visibleCategories);
        }

        public synchronized Set<String> getAllCategories() {
            return Collections.unmodifiableSet(this.allCategories);
        }

        public synchronized void setVisible(String category, boolean visible) {
            if (!this.allCategories.contains(category)) {
                return;
            }
            if (visible) {
                if (this.visibleCategories.add(category)) {
                    this.fireChange();
                }
            } else if (this.visibleCategories.remove(category)) {
                this.fireChange();
            }
        }

        public synchronized void setAllVisible(boolean visible) {
            if (visible) {
                boolean notify;
                boolean bl = notify = this.visibleCategories.size() != this.allCategories.size();
                if (this.visibleCategories.addAll(this.allCategories) && notify) {
                    this.fireChange();
                }
            } else {
                boolean notify = !this.visibleCategories.isEmpty();
                this.visibleCategories.clear();
                if (notify) {
                    this.fireChange();
                }
            }
        }
    }
}

