/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.marks;

import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.marks.MarksSelectionController;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.model.spi.InfoPanelContentProvider;
import com.azul.log.gui.support.SimpleRecordInfoPanelContent;
import com.azul.log.gui.ui.Markline;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.Color;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Mark
extends UIElement
implements Comparable<Mark> {
    public static final String USER_CATEGORY = "user";
    private static final Pattern colorPattern = Pattern.compile("^(#[0-9A-Fa-f]{6}):(.*)$");
    private final boolean isUserMark;
    private final String category;
    private final String storeId;
    private String label;

    private Mark(RelativeTimestamp timestamp, int lineNumber, String category, String label, boolean isUserMark, LogModel logModel) {
        super(timestamp, lineNumber, logModel);
        this.category = category;
        this.label = label;
        this.isUserMark = isUserMark;
        this.storeId = logModel.getLogUID();
        this.ic.add(MarksSelectionController.getInstance());
        this.ic.add(new InfoPanelContentProviderImpl());
    }

    public static Mark create(RelativeTimestamp timestamp, int lineNumber, String category, String label, boolean isUserMark, LogModel logModel) {
        return new Mark(timestamp, lineNumber, category, label, isUserMark, logModel);
    }

    static Mark fromExternalString(LogModel logModel, String str) throws IllegalArgumentException {
        String[] v = str.split(":", 4);
        if (v.length != 4) {
            throw new IllegalArgumentException("Cannot Parse Mark '" + str + "'");
        }
        try {
            RelativeTimestamp ts = RelativeTimestamp.of(Double.parseDouble(v[0]), LogUnits.MILLISECONDS);
            int lineNumber = Integer.parseInt(v[1]);
            String category = v[2];
            Matcher matcher = colorPattern.matcher(v[3]);
            if (matcher.matches()) {
                String color = matcher.group(1);
                Markline.AttributesProvider.setPreferredCategoryColor(category, Color.decode(color));
                v[3] = matcher.group(2);
            }
            String label = v[3];
            return Mark.create(ts, lineNumber, category, label, true, logModel);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Cannot Parse Mark '" + str + "' - " + ex.getMessage());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getCategory() {
        return this.category;
    }

    String getStoreId() {
        return this.storeId;
    }

    public void setLabel(String label, boolean notifyListeners) {
        if (label == null) {
            throw new NullPointerException();
        }
        if (!label.equals(this.label)) {
            this.label = label;
            if (notifyListeners) {
                MarksModel.fireModelChange();
            }
        }
    }

    public boolean isSelected() {
        return this.equals(UIElementSelectionModel.getInstance().getSelectedElement());
    }

    public boolean isUserMark() {
        return this.isUserMark;
    }

    String toExternalString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%.5f", this.getRawTimestamp().getInUnits(LogUnits.MILLISECONDS))).append(':');
        sb.append(this.getLogLineNumber()).append(':');
        sb.append(this.category).append(':');
        Color color = Markline.AttributesProvider.getLineColor(this.category);
        sb.append(String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue())).append(':');
        sb.append(this.label);
        return sb.toString();
    }

    @Override
    public int compareTo(Mark o) {
        return Long.compare(this.getLogLineNumber(), o.getLogLineNumber());
    }

    public boolean belongsTo(LogModel logModel) {
        return Objects.equals(logModel.getLogUID(), this.storeId);
    }

    private class InfoPanelContentProviderImpl
    implements InfoPanelContentProvider {
        private InfoPanelContentProviderImpl() {
        }

        @Override
        public InfoPanelContentProvider.InfoPanelContent getInfoPanelContent() {
            LogRecord record = Context.lookup(LogModel.class).getRecordsMap().getRecordAtLine(Mark.this.getLogLineNumber());
            return new SimpleRecordInfoPanelContent(record, Mark.this.getLogLineContent());
        }
    }
}

