/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.graphs.api;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.GraphsDefinitionProvider;
import com.azul.log.model.api.LogModel;
import com.azul.log.utils.ProgressModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public final class PlotData {
    private final List<GraphDefinition> definitions;

    private PlotData(List<GraphDefinition> definitions) {
        this.definitions = definitions;
    }

    public static PlotData create(LogModel model, ProgressModel progress) {
        List<? extends GraphDefinition> tmp = PlotData.createDefinitions(model);
        progress.setMaximum(tmp.size() + 1);
        Map map = tmp.stream().peek(gd -> progress.addProgress(1L)).collect(Collectors.toMap(GraphDefinition::getID, Function.identity(), (gd1, gd2) -> {
            if (gd1.hasData() && gd2.hasData()) {
                String msg = String.format("Both GDs have data! %s/%s and %s/%s", gd1.getCategoryName(), gd1.getTitle(), gd2.getCategoryName(), gd2.getTitle());
                Logger.getLogger(PlotData.class.getName()).log(Level.WARNING, msg);
            }
            return gd1.hasData() ? gd1 : gd2;
        }));
        ArrayList<GraphDefinition> definitions = new ArrayList<GraphDefinition>(map.values());
        definitions.sort(new ComparatorImpl());
        progress.addProgress(1L);
        return new PlotData(definitions);
    }

    private static List<? extends GraphDefinition> createDefinitions(LogModel logModel) {
        return logModel == null ? Collections.emptyList() : Lookup.getDefault().lookupAll(GraphsDefinitionProvider.class).parallelStream().map(p -> p.getGraphsDefinition(logModel)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<GraphDefinition> getGraphDefinitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    public int getGraphsCount() {
        return this.definitions.size();
    }

    public String getGraphName(int index) {
        return this.getGraphDefinition(index).getTitle();
    }

    public String getGraphCategory(int index) {
        return this.getGraphDefinition(index).getCategoryName();
    }

    public GraphDefinition getGraphDefinition(int index) {
        return this.definitions.get(index);
    }

    public String getGraphNameByID(int id) {
        GraphDefinition gd = this.getGraphDefinitionByID(id);
        return gd == null ? null : gd.getTitle();
    }

    public GraphDefinition getGraphDefinitionByID(int id) {
        return this.definitions.stream().filter(d -> d.getID() == id).findAny().orElse(null);
    }

    private static class ComparatorImpl
    implements Comparator<GraphDefinition>,
    Serializable {
        private ComparatorImpl() {
        }

        @Override
        public int compare(GraphDefinition o1, GraphDefinition o2) {
            int categoryPositionDelta = o1.getCategory().position - o2.getCategory().position;
            if (categoryPositionDelta != 0) {
                return categoryPositionDelta;
            }
            int categoryNameDelta = o1.getCategoryName().compareTo(o2.getCategoryName());
            if (categoryNameDelta != 0) {
                return categoryNameDelta;
            }
            int graphPositionDelta = o1.getPosition() - o2.getPosition();
            if (graphPositionDelta != 0) {
                return graphPositionDelta;
            }
            return o1.getTitle().compareTo(o2.getTitle());
        }
    }
}

