/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.graphs.api;

import com.azul.log.gui.graphs.annotations.DistinctGraphDescription;
import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.annotations.GraphsDescription;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphCategory;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.spi.ColorsProvider;
import com.azul.log.gui.graphs.spi.GraphDescriptionFilter;
import com.azul.log.gui.graphs.spi.GraphSeries;
import com.azul.log.gui.graphs.spi.SeriesComparator;
import com.azul.log.gui.model.api.PersistentDistinctValuesModel;
import com.azul.log.gui.ui.ColorPalette;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogDataAggregator;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.Aggregation;
import com.azul.log.parser.utils.TextUtils;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GraphsDefinitionProvider {
    public Collection<? extends GraphDefinition> getGraphsDefinition(LogModel logModel) {
        LinkedList<GraphDefinition> result = new LinkedList<GraphDefinition>();
        for (Annotation description : this.getClass().getAnnotations()) {
            if (!(description instanceof GraphsDescription)) continue;
            result.addAll(this.createDefinitions(logModel, (GraphsDescription)description));
        }
        return result;
    }

    protected List<GraphDefinition> createDefinitions(LogModel logModel, GraphsDescription description) {
        if (!description.model().equals(logModel.getModelID())) {
            return Collections.emptyList();
        }
        ArrayList<GraphDefinition> result = new ArrayList<GraphDefinition>();
        GraphCategory category = new GraphCategory(description);
        for (GraphDescription graphDescription : description.graphs()) {
            try {
                if (!graphDescription.filter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).isApplicable(logModel)) {
                    continue;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new InternalError(ex.getMessage());
            }
            result.add(this.createDefinition(logModel, category, graphDescription, null, null));
        }
        for (Annotation annotation : description.distinct_graphs()) {
            try {
                if (!annotation.filter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).isApplicable(logModel)) {
                    continue;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new InternalError(ex.getMessage());
            }
            try {
                String[] valuesArray;
                for (String dv : valuesArray = this.getDistinctValues(logModel, annotation.source(), annotation.distinct_field(), null, null, null)) {
                    result.add(this.createDefinition(logModel, category, new GraphDescription((DistinctGraphDescription)annotation, dv){
                        final /* synthetic */ DistinctGraphDescription val$descr;
                        final /* synthetic */ String val$dv;
                        {
                            this.val$descr = distinctGraphDescription;
                            this.val$dv = string;
                        }

                        @Override
                        public int position() {
                            return this.val$descr.position();
                        }

                        @Override
                        public String title() {
                            return this.val$descr.title().replace("{dv}", this.val$dv);
                        }

                        @Override
                        public GraphSeries[] series() {
                            return this.val$descr.series();
                        }

                        @Override
                        public String xlabel() {
                            return this.val$descr.xlabel();
                        }

                        @Override
                        public String ylabel() {
                            return this.val$descr.ylabel();
                        }

                        @Override
                        public Class<? extends SeriesComparator> series_comparator() {
                            return this.val$descr.series_comparator();
                        }

                        @Override
                        public Class<? extends LogRecordLabelConverter> label_converter() {
                            return this.val$descr.label_converter();
                        }

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return this.val$descr.annotationType();
                        }

                        @Override
                        public Class<? extends GraphDescriptionFilter> filter() {
                            return this.val$descr.filter();
                        }

                        @Override
                        public LogUnits units() {
                            return LogUnits.UNSPECIFIED;
                        }
                    }, annotation.distinct_field(), dv));
                }
            }
            catch (NoSuchFieldException ex) {
                Logger.getLogger(GraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    private GraphDefinition createDefinition(LogModel logModel, GraphCategory category, GraphDescription descr, String filter_field, String filter_value) throws NumberFormatException, SecurityException {
        GraphSeries[] series = descr.series();
        ArrayList<DataSeries> graphData = new ArrayList<DataSeries>(series.length);
        ArrayList<DataSeries> distinctGraphData = new ArrayList<DataSeries>();
        Iterator<Color> colorIterator = ColorPalette.iterator();
        for (GraphSeries ser : series) {
            Class<? extends LogRecord> klass = ser.source();
            String fieldName = ser.field();
            try {
                String filterMethodName;
                Field fld = klass.getField(fieldName);
                HashMap<Field, String> fieldFilters = new HashMap<Field, String>();
                if (filter_value != null && !filter_value.isEmpty()) {
                    fieldFilters.put(klass.getField(filter_field), filter_value);
                }
                String seriesFilterField = ser.filter_field();
                String seriesFilterValue = ser.filter_value();
                if (!seriesFilterField.isEmpty()) {
                    fieldFilters.put(klass.getField(seriesFilterField), seriesFilterValue);
                }
                Method filterMethod = (filterMethodName = ser.filter()).isEmpty() ? null : klass.getMethod(filterMethodName, new Class[0]);
                String distinctFldName = ser.distinct_field();
                String color = ser.color();
                Color definedColor = color != null && !color.isEmpty() ? Color.decode(color) : null;
                LogUnits targetUnits = descr.units();
                LogDataConverterImpl converter = new LogDataConverterImpl(fld, targetUnits);
                if (!distinctFldName.isEmpty()) {
                    String label = ser.label();
                    String[] valuesArray = this.getDistinctValues(logModel, klass, distinctFldName, null, filterMethod, fieldFilters);
                    PersistentDistinctValuesModel model = PersistentDistinctValuesModel.getModel(category.name + descr.title());
                    Class<? extends ColorsProvider> colorsProviderClass = ser.colors_provider();
                    ColorsProvider colorsProvider = null;
                    if (!ColorsProvider.Default.class.equals(colorsProviderClass)) {
                        try {
                            colorsProvider = colorsProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    for (String dv : valuesArray) {
                        Color c;
                        HashMap<Field, String> fieldFiltersDV = new HashMap<Field, String>(fieldFilters);
                        fieldFiltersDV.put(klass.getField(distinctFldName), dv);
                        LogRecordsList<LogRecord> data = logModel.getRecordsMap().getRecords(klass, this.getAggregator(ser), converter, filterMethod, fieldFiltersDV);
                        String lbl = label.replace("{dv}", TextUtils.toCamelCase(dv));
                        Color color2 = c = colorsProvider == null ? null : colorsProvider.getColor(dv);
                        if (c == null) {
                            c = definedColor == null ? ColorPalette.get(model.getValueIndex(lbl)) : definedColor;
                        }
                        distinctGraphData.add(new DataSeries(lbl, c, data, converter, ser.default_state()));
                        if (definedColor == null) continue;
                        definedColor = definedColor.brighter();
                    }
                    continue;
                }
                LogRecordsList<LogRecord> data = logModel.getRecordsMap().getRecords(klass, this.getAggregator(ser), converter, filterMethod, fieldFilters);
                Color c = definedColor == null ? colorIterator.next() : definedColor;
                graphData.add(new DataSeries(ser.label(), c, data, converter, ser.default_state()));
            }
            catch (NoSuchFieldException | NoSuchMethodException ex) {
                Logger.getLogger(GraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            Class<? extends SeriesComparator> seriesComparator = descr.series_comparator();
            SeriesComparator cmp = seriesComparator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            distinctGraphData.sort(cmp);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.getLogger(GraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        graphData.addAll(0, distinctGraphData);
        LogRecordLabelConverter labelConverter = null;
        if (descr.label_converter() != GraphDescription.DefaultLabelConverter.class) {
            try {
                labelConverter = descr.label_converter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getLogger(GraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new GraphDefinition(logModel, category, descr, graphData, labelConverter);
    }

    private LogDataAggregator getAggregator(GraphSeries ser) throws InternalError {
        LogDataAggregator aggregator;
        switch (ser.aggregation()) {
            case COUNT: {
                aggregator = new CountingAggregator();
                break;
            }
            case SUM: {
                aggregator = new SumAggregator();
                break;
            }
            case UNSPECIFIED: {
                aggregator = null;
                break;
            }
            default: {
                throw new InternalError("Unhandled aggregation type " + (Object)((Object)ser.aggregation()));
            }
        }
        return aggregator;
    }

    private String[] getDistinctValues(LogModel logModel, Class<? extends LogRecord> klass, String distinctFldName, LogDataConverter converter, Method filterMethod, Map<Field, String> fieldFilters) throws NoSuchFieldException {
        LogRecordsList data = logModel.getRecordsMap().getRecords(klass, null, converter, filterMethod, fieldFilters);
        Field distinctFld = klass.getField(distinctFldName);
        HashMap<Object, String> values = new HashMap<Object, String>();
        for (LogRecord record : data) {
            try {
                Object obj = distinctFld.get(record);
                if (obj == null) continue;
                values.computeIfAbsent(obj, Object::toString);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(GraphsDefinitionProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Object[] result = values.values().toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    static {
        JFreeChartRecordElement.GraphsDefinitionProviderAccessor.setInstance(new FieldAccessor());
    }

    private static class SumAggregator
    extends LogDataAggregator {
        private double sum;

        public SumAggregator() {
            super(Aggregation.SUM);
        }

        @Override
        public Double aggregate(LogRecord record, LogDataConverter converter) {
            this.sum += converter.getValue(record).doubleValue();
            return this.sum;
        }
    }

    private static class CountingAggregator
    extends LogDataAggregator {
        private final AtomicLong counter = new AtomicLong();

        public CountingAggregator() {
            super(Aggregation.COUNT);
        }

        @Override
        public Double aggregate(LogRecord record, LogDataConverter converter) {
            return this.counter.incrementAndGet();
        }
    }

    private static class FieldAccessor
    extends JFreeChartRecordElement.GraphsDefinitionProviderAccessor {
        private FieldAccessor() {
        }

        @Override
        protected Field getField(GraphDefinition graphDefinition, int seriesIndex) {
            DataSeries series = graphDefinition.getGraphData().get(seriesIndex);
            LogDataConverter converter = series.getConverter();
            if (converter instanceof LogDataConverterImpl) {
                LogDataConverterImpl c = (LogDataConverterImpl)converter;
                return c.fld;
            }
            return null;
        }
    }

    static class LogDataConverterImpl
    implements LogDataConverter {
        private final Field fld;
        private final LogUnits targetUnits;
        private final NumberFormat valueFormat;
        private final boolean isIntegerValue;

        public LogDataConverterImpl(Field fld, LogUnits targetUnits) {
            this.fld = fld;
            this.targetUnits = targetUnits;
            this.isIntegerValue = this.isIntegerType(fld);
            this.valueFormat = UIUtils.getNumberFormat();
        }

        @Override
        public String getValueAsText(LogRecord record, int valueFractionDigits) {
            return this.getValueAsText(this.getValue(record), valueFractionDigits);
        }

        @Override
        public String getValueAsText(Double value, int valueFractionDigits) {
            if (!this.isIntegerValue) {
                valueFractionDigits = Math.max(3, valueFractionDigits);
                this.valueFormat.setMaximumFractionDigits(valueFractionDigits);
                this.valueFormat.setMinimumFractionDigits(valueFractionDigits);
            }
            return this.valueFormat.format(value) + " " + (Object)((Object)this.getValueUnits());
        }

        @Override
        public Double getValue(LogRecord record) {
            return record.getDoubleValue(this.fld, this.targetUnits);
        }

        @Override
        public final LogUnits getValueUnits() {
            return this.targetUnits;
        }

        private boolean isIntegerType(Field fld) {
            return fld.getType() == Integer.TYPE || fld.getType() == Long.TYPE || fld.getType() == Short.TYPE;
        }
    }
}

