/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.graphs.api;

import com.azul.log.gui.graphs.annotations.GraphDescription;
import com.azul.log.gui.graphs.api.DataSeries;
import com.azul.log.gui.graphs.api.GraphCategory;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.spi.LogRecordLabelConverter;
import java.util.List;

public final class GraphDefinition {
    private final int id;
    private final GraphDescription descr;
    private final GraphCategory category;
    private final List<DataSeries> data;
    private final LogRecordLabelConverter labelConverter;
    private final LogModel logModel;

    GraphDefinition(LogModel logModel, GraphCategory category, GraphDescription descr, List<DataSeries> data, LogRecordLabelConverter labelConverter) {
        this.logModel = logModel;
        this.descr = descr;
        this.category = category;
        this.data = data;
        this.labelConverter = labelConverter;
        this.id = (logModel.getLogUID() + this.getCategoryName() + this.getTitle()).hashCode();
    }

    public String getTitle() {
        return this.descr.title();
    }

    public LogUnits getUnits() {
        return this.descr.units();
    }

    public String getCategoryName() {
        return this.category.name;
    }

    public GraphCategory getCategory() {
        return this.category;
    }

    public int getID() {
        return this.id;
    }

    public int getPosition() {
        return this.descr.position();
    }

    public String getXLabel() {
        return this.descr.xlabel();
    }

    public String getYLabel() {
        String label = this.descr.ylabel();
        if (label.isEmpty()) {
            String units = this.getUnits().getAbbreviation();
            label = "Value" + (units.isEmpty() ? "" : " (" + units + ")");
        }
        return label;
    }

    public List<DataSeries> getGraphData() {
        return this.data;
    }

    public LogRecord getRecord(int seriesIndex, int itemIndex) {
        return this.getGraphData().get(seriesIndex).getData().get(itemIndex);
    }

    public LogRecordLabelConverter getLabelConverter() {
        return this.labelConverter;
    }

    public String getDefaultSaveAsFileName() {
        StringBuilder sb = new StringBuilder();
        boolean inChar = false;
        for (char c : (this.getCategoryName() + " " + this.descr.title()).toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                inChar = true;
                sb.append(c);
                continue;
            }
            if (!inChar) continue;
            sb.append('_');
            inChar = false;
        }
        while (sb.charAt(sb.length() - 1) == '_') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean hasData() {
        return !this.getGraphData().stream().map(DataSeries::getData).allMatch(LogRecordsList::isEmpty);
    }

    public boolean[] getInitialSeriesVisibilityState() {
        boolean[] result = new boolean[this.data.size()];
        int i = 0;
        for (DataSeries dataSeries : this.data) {
            result[i++] = !dataSeries.getDefaultState().equals("hidden");
        }
        return result;
    }

    public LogModel getLogModel() {
        return this.logModel;
    }
}

