/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.Markline;
import com.azul.log.gui.ui.ToolbarButton;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public final class MarksActions {
    private static final UIElementSelectionModel selectionModel = UIElementSelectionModel.getInstance();
    private static final ConcurrentHashMap<String, Color> preferredColors = new ConcurrentHashMap();
    private static boolean enabled = true;
    private static final MarkAction DELETE = new MarkAction("Delete Mark", KeyStroke.getKeyStroke(127, 0), "mark-delete"){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarksModel model = MarksActions.getModel();
            Mark mark = (Mark)selectionModel.getSelectedElement();
            model.removeMark(mark);
            selectionModel.clearSelection();
        }

        @Override
        public boolean isEnabled() {
            if (!enabled || MarksActions.getModel() == null) {
                return false;
            }
            UIElement selectedElement = selectionModel.getSelectedElement();
            if (!(selectedElement instanceof Mark)) {
                return false;
            }
            return ((Mark)selectedElement).isUserMark();
        }
    };
    private static String lastCategory = null;
    private static final MarkAction CREATE = new MarkAction("Add Mark", KeyStroke.getKeyStroke(77, 64), "mark-create"){

        @Override
        public void actionPerformed(ActionEvent e) {
            preferredColors.clear();
            EditMarkPanel panel = new EditMarkPanel(null, lastCategory);
            UIElement selection = selectionModel.getSelectedElement();
            int response = JOptionPane.showConfirmDialog(MainFrame.get(), panel, "Create New Mark", 2, 1, this.icon);
            if (response != 0) {
                return;
            }
            Markline.AttributesProvider.updatePreferredColors(preferredColors);
            String label = panel.getLabel();
            if (!label.isEmpty()) {
                lastCategory = panel.getCategory();
                RelativeTimestamp timestamp = selection.getRawTimestamp();
                int logLineNumber = selection.getLogLineNumber();
                Mark mark = Mark.create(timestamp, logLineNumber, lastCategory, label, true, selection.getLogModel());
                MarksActions.getModel().addMark(mark);
                selectionModel.setSelectedElement(mark);
            }
        }

        @Override
        public boolean isEnabled() {
            if (!enabled || MarksActions.getModel() == null) {
                return false;
            }
            UIElement selection = selectionModel.getSelectedElement();
            return selection != null && !(selection instanceof Mark);
        }
    };
    private static final AbstractButton toolbarPresenter = MarksActions.initToolbarPresenter();
    private static final MarkAction EDIT = new MarkAction("Edit Mark", KeyStroke.getKeyStroke(77, 64), "mark-edit"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Mark mark = (Mark)selectionModel.getSelectedElement();
            preferredColors.clear();
            EditMarkPanel panel = new EditMarkPanel(mark.getLabel(), mark.getCategory());
            int response = JOptionPane.showConfirmDialog(MainFrame.get(), panel, "Modify Mark", 2, 1, this.icon);
            String label = panel.getLabel();
            if (response != 0) {
                return;
            }
            lastCategory = panel.getCategory();
            Markline.AttributesProvider.updatePreferredColors(preferredColors);
            if (!label.isEmpty()) {
                mark.setLabel(label, true);
            }
            selectionModel.setSelectedElement(mark);
        }

        @Override
        public boolean isEnabled() {
            if (!enabled || MarksActions.getModel() == null) {
                return false;
            }
            UIElement selection = selectionModel.getSelectedElement();
            return selection instanceof Mark && ((Mark)selection).isUserMark();
        }
    };

    private MarksActions() {
    }

    private static MarksModel getModel() {
        return Context.lookup(MarksModel.class);
    }

    public static void createMarkFromSelection() {
        if (CREATE.isEnabled()) {
            CREATE.actionPerformed(null);
        }
    }

    public static JMenu getMenuPresenter() {
        JMenu menu = new JMenu("Marks");
        JMenuItem create = new JMenuItem();
        create.setAction(CREATE);
        create.setText(CREATE.descr);
        create.setAccelerator(CREATE.keyStroke);
        menu.add(create);
        JMenuItem edit = new JMenuItem();
        edit.setAction(EDIT);
        edit.setText(EDIT.descr);
        edit.setAccelerator(EDIT.keyStroke);
        menu.add(edit);
        JMenuItem delete = new JMenuItem();
        delete.setAction(DELETE);
        delete.setText(DELETE.descr);
        delete.setAccelerator(DELETE.keyStroke);
        menu.add(delete);
        return menu;
    }

    public static void enable(boolean enabled) {
        MarksActions.enabled = enabled;
        Action action = toolbarPresenter.getAction();
        toolbarPresenter.setEnabled(action != null && action.isEnabled());
    }

    public static void registerActions(ActionMap actionMap, InputMap inputMap) {
        actionMap.put(CREATE.name, CREATE);
        actionMap.put(DELETE.name, DELETE);
        actionMap.put(EDIT.name, EDIT);
        inputMap.put(MarksActions.getKeystroke(CREATE), CREATE.name);
        inputMap.put(MarksActions.getKeystroke(DELETE), DELETE.name);
        inputMap.put(MarksActions.getKeystroke(EDIT), EDIT.name);
    }

    private static AbstractButton initToolbarPresenter() {
        final ToolbarButton button = new ToolbarButton(null, "Manage Marklines", "markline");
        final Icon icon = button.getIcon();
        final String tooltip = button.getToolTipText();
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UIElement selection = selectionModel.getSelectedElement();
                if (selection instanceof Mark) {
                    this.setAction(button, DELETE);
                } else if (selection != null) {
                    this.setAction(button, CREATE);
                } else {
                    button.setAction(null);
                    button.setIcon(icon);
                    button.setToolTipText(tooltip);
                    button.setEnabled(false);
                }
            }

            private void setAction(AbstractButton button2, MarkAction a) {
                button2.setAction(a);
                button2.setIcon(a.icon);
                String m = KeyEvent.getModifiersExText(a.keyStroke.getModifiers());
                String ks = (m.isEmpty() ? "" : m + "+") + KeyEvent.getKeyText(a.keyStroke.getKeyCode());
                button2.setToolTipText(a.descr + " (" + ks + ")");
            }
        };
        selectionModel.addChangeListener(listener);
        listener.stateChanged(null);
        return button;
    }

    public static AbstractButton getToolbarPresenter() {
        return toolbarPresenter;
    }

    private static KeyStroke getKeystroke(AbstractAction action) throws IllegalArgumentException {
        if (!(action instanceof MarkAction)) {
            throw new IllegalArgumentException();
        }
        return ((MarkAction)action).keyStroke;
    }

    private static Color getCategoryColor(String category) {
        Color color = preferredColors.get(category);
        if (color == null) {
            color = Markline.AttributesProvider.getLineColor(category);
            preferredColors.put(category, color);
        }
        return color;
    }

    private static void setCategoryColor(String category, Color color) {
        preferredColors.put(category, color);
    }

    private static final class ColorIcon
    implements Icon {
        private final Rectangle bounds = new Rectangle();
        private Color color;

        private ColorIcon() {
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics g2 = g.create();
            g.getClipBounds(this.bounds);
            int shift = this.bounds.height / 6;
            int size = this.bounds.height - shift - shift;
            g2.translate(shift, shift);
            g2.setColor(this.color);
            g2.fillRect(0, 0, size, size);
            g2.setColor(Color.black);
            g2.drawRect(0, 0, size, size);
            g2.dispose();
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    private static class CategoryEditor
    extends BasicComboBoxEditor {
        private CategoryEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            JPanel tmp = new JPanel();
            tmp.add(new JLabel("[]"));
            JTextField fld = super.createEditorComponent();
            fld.setBorder(new EmptyBorder(0, Math.max(0, tmp.getPreferredSize().height), 0, 0){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    super.paintBorder(c, g, x, y, width, height);
                    int shift = height / 5;
                    int size = height - shift - shift;
                    g.translate(shift, shift);
                    g.setColor(MarksActions.getCategoryColor(this.getText()));
                    g.fillRect(0, 0, size, size);
                    g.setColor(Color.black);
                    g.drawRect(0, 0, size, size);
                }
            });
            return fld;
        }

        private void addDocumentListener(DocumentListener listener) {
            this.editor.getDocument().addDocumentListener(listener);
        }

        private String getText() {
            return this.editor.getText().trim();
        }
    }

    private static final class CategoryRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private final ColorIcon icon = new ColorIcon();

        public CategoryRenderer() {
            this.setIcon(this.icon);
            JPanel tmp = new JPanel();
            tmp.add(new JLabel("[]"));
            this.setBorder(new EmptyBorder(0, Math.max(0, tmp.getPreferredSize().height - 24), 0, 0));
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value);
            this.icon.setColor(MarksActions.getCategoryColor(value));
            this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.text);
            this.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }
    }

    private static final class EditMarkPanel
    extends JPanel {
        private final JTextField fldLabel = UIUtils.fixCopyPasteActionHotKeys(new JTextField());
        private final JComboBox<String> cbCategory = new JComboBox();
        private final JButton btnColor = new JButton();

        public EditMarkPanel(String label, String selectedCategory) {
            JLabel lblLabel = new JLabel();
            JLabel lblCategory = new JLabel();
            lblLabel.setLabelFor(this.fldLabel);
            lblLabel.setText("Label");
            lblLabel.setDisplayedMnemonic('L');
            lblCategory.setLabelFor(this.cbCategory);
            lblCategory.setText("Category");
            lblCategory.setDisplayedMnemonic('C');
            this.fldLabel.setText(label);
            this.cbCategory.setEnabled(label == null);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            boolean selectedCategoryExists = false;
            for (String category : MarksActions.getModel().getCategoriesModel().getAllCategories()) {
                model.addElement(category);
                selectedCategoryExists |= category.equals(selectedCategory);
            }
            if (!selectedCategoryExists) {
                selectedCategory = "user";
            }
            model.setSelectedItem(selectedCategory);
            this.cbCategory.setModel(model);
            this.cbCategory.setEditable(true);
            this.cbCategory.setRenderer(new CategoryRenderer());
            final CategoryEditor editor = new CategoryEditor();
            editor.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateColor();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateColor();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateColor();
                }

                private void updateColor() {
                    String category = editor.getText();
                    btnColor.setBackground(MarksActions.getCategoryColor(category));
                }
            });
            this.btnColor.addActionListener(e -> SwingUtilities.invokeLater(() -> {
                Color c = JColorChooser.showDialog(MainFrame.get(), "Select Custom Color", MarksActions.getCategoryColor(editor.getText()));
                if (c != null) {
                    MarksActions.setCategoryColor(editor.getText(), c);
                    this.btnColor.setBackground(c);
                    this.cbCategory.invalidate();
                    this.cbCategory.repaint();
                }
            }));
            this.cbCategory.setEditor(editor);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblCategory, -1, -1, Short.MAX_VALUE).addComponent(lblLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLabel).addComponent(this.cbCategory, 0, 255, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnColor, -2, 60, -2).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fldLabel, -2, -1, -2).addComponent(lblLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cbCategory, -2, -1, -2).addComponent(lblCategory))).addComponent(this.btnColor, -2, 60, -2)).addContainerGap()));
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    if (event.getAncestor() instanceof JDialog) {
                        final Window dialog = (Window)event.getAncestor();
                        dialog.addWindowFocusListener(new WindowFocusListener(){

                            @Override
                            public void windowGainedFocus(WindowEvent e) {
                                fldLabel.requestFocusInWindow();
                                dialog.removeWindowFocusListener(this);
                            }

                            @Override
                            public void windowLostFocus(WindowEvent e) {
                            }
                        });
                        dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                fldLabel.requestFocusInWindow();
                                dialog.removeWindowListener(this);
                            }
                        });
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container container, Component comp) {
                    if (comp == fldLabel) {
                        return cbCategory;
                    }
                    if (comp instanceof JTextField) {
                        return btnColor;
                    }
                    return null;
                }

                @Override
                public Component getComponentBefore(Container container, Component comp) {
                    if (comp == btnColor) {
                        return cbCategory;
                    }
                    if (comp == fldLabel) {
                        return null;
                    }
                    if (comp instanceof JTextField) {
                        return fldLabel;
                    }
                    return null;
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return fldLabel;
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return btnColor;
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return fldLabel;
                }
            });
        }

        public String getLabel() {
            return this.fldLabel.getText().trim();
        }

        private String getCategory() {
            return (String)this.cbCategory.getSelectedItem();
        }
    }

    private static abstract class MarkAction
    extends AbstractAction {
        protected final Icon icon;
        private final KeyStroke keyStroke;
        private final String name;
        private final String descr;

        public MarkAction(String descr, KeyStroke keyStroke, String name) {
            this.name = name;
            this.keyStroke = keyStroke;
            this.descr = descr;
            selectionModel.addChangeListener(e -> this.setEnabled(this.isEnabled()));
            this.icon = "mark-edit".equals(name) ? null : UIUtils.loadIcon("/mark/" + name + ".png");
        }
    }
}

