/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.model.Context;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;

public abstract class GlobalContextAction<T>
extends AbstractAction {
    private final Lookup.Result<T> result;
    private final Lookup.Template<T> template;

    protected GlobalContextAction(Class<T> type) {
        this.template = new Lookup.Template<T>(type);
        this.result = Context.lookup(this.template);
        this.result.addLookupListener(e -> this.update());
        this.update();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new InternalError();
        }
        if (this.isEnabled()) {
            this.actionPerformed(this.getItem());
        }
    }

    protected abstract void actionPerformed(T var1);

    protected T getItem() {
        return Context.lookup(this.template.getType());
    }

    protected boolean isEnabledForItem(T item) {
        return true;
    }

    private void update() {
        T item = this.getItem();
        boolean b = item != null && this.isEnabledForItem(item);
        SwingUtilities.invokeLater(() -> this.setEnabled(b));
    }
}

