/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.BaseTime;
import com.azul.jvm.time.TimeIterable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class TimeStep {
    public final long val;
    public final TimeUnit unit;
    public final TimeUnit displayUnit;

    public static <T extends BaseTime<T>> TimeStep naturalStep(T startTime, T endTime, int maxSteps) {
        if (endTime.diff(startTime, TimeUnit.DAYS) > 7L) {
            return TimeStep.naturalStepHelper(TimeUnit.DAYS, startTime, endTime, maxSteps);
        }
        if (endTime.diff(startTime, TimeUnit.DAYS) > 3L) {
            return TimeStep.naturalStepHelper(TimeUnit.HOURS, startTime, endTime, maxSteps).withDisplay(TimeUnit.DAYS);
        }
        if (endTime.diff(startTime, TimeUnit.HOURS) > 4L) {
            return TimeStep.naturalStepHelper(TimeUnit.MINUTES, startTime, endTime, maxSteps).withDisplay(TimeUnit.HOURS);
        }
        if (endTime.diff(startTime, TimeUnit.HOURS) > 1L) {
            return TimeStep.naturalStepHelper(TimeUnit.MINUTES, startTime, endTime, maxSteps);
        }
        if (endTime.diff(startTime, TimeUnit.MINUTES) > 15L) {
            return TimeStep.naturalStepHelper(TimeUnit.MINUTES, startTime, endTime, maxSteps).withDisplay(TimeUnit.MINUTES);
        }
        if (endTime.diff(startTime, TimeUnit.MINUTES) > 1L) {
            return TimeStep.naturalStepHelper(TimeUnit.SECONDS, startTime, endTime, maxSteps).withDisplay(TimeUnit.MINUTES);
        }
        return TimeStep.naturalStepHelper(TimeUnit.SECONDS, startTime, endTime, maxSteps);
    }

    public static TimeStep ofMillis(long val) {
        return TimeStep.makeMillis(val);
    }

    public static TimeStep makeMillis(long val) {
        return TimeStep.make(val, TimeUnit.MILLISECONDS);
    }

    public static TimeStep ofSeconds(long val) {
        return TimeStep.makeSeconds(val);
    }

    public static TimeStep makeSeconds(long val) {
        return TimeStep.make(val, TimeUnit.SECONDS);
    }

    public static TimeStep make(long val, TimeUnit unit) {
        return new TimeStep(val, unit);
    }

    public TimeStep(long val, TimeUnit unit) {
        this(val, unit, unit);
    }

    private TimeStep(long val, TimeUnit unit, TimeUnit displayUnit) {
        this.val = val;
        this.unit = unit;
        this.displayUnit = displayUnit;
    }

    public final TimeStep withDisplay(TimeUnit unit) {
        return new TimeStep(this.val, this.unit, unit);
    }

    public final TimeStep convert(TimeUnit unit) {
        return new TimeStep(unit.convert(this.val, this.unit), unit);
    }

    public final <T extends BaseTime<T>> Iterable<T> iterate(T start, T end) {
        return new TimeIterable<T>(start, end, this);
    }

    public final TimeStep naturalDiv(int divisor) {
        long rem;
        if (this.val < (long)divisor) {
            TimeStep thisStep = this.convert(TimeStep.finerUnit(this.unit));
            return thisStep.naturalDiv(divisor);
        }
        int[] possibleDivisors = new int[]{divisor, TimeStep.naturalUpper(divisor), TimeStep.naturalLower(divisor)};
        Set<Integer> naturalMultiples = TimeStep.naturalMultiplierSet(this.unit);
        for (int possibleDivisor : possibleDivisors) {
            int newVal;
            rem = this.val % (long)possibleDivisor;
            if (rem != 0L || !naturalMultiples.contains(newVal = (int)(this.val / (long)possibleDivisor))) continue;
            return TimeStep.make(newVal, this.unit);
        }
        for (int possibleDivisor : possibleDivisors) {
            rem = this.val % (long)possibleDivisor;
            if (rem != 0L) continue;
            long newVal = this.val / (long)possibleDivisor;
            return TimeStep.make(newVal, this.unit);
        }
        return TimeStep.make(this.val / (long)divisor, this.unit);
    }

    public final String toString() {
        return this.val + " " + (Object)((Object)this.unit);
    }

    private static <T extends BaseTime<T>> TimeStep naturalStepHelper(TimeUnit unit, T startTime, T endTime, int maxSteps) {
        long diff = endTime.diff(startTime, unit);
        for (int multiplier : TimeStep.naturalMultipliers(unit)) {
            if (diff / (long)multiplier >= (long)maxSteps) continue;
            return new TimeStep(multiplier, unit);
        }
        return new TimeStep(diff / (long)maxSteps, unit);
    }

    private static int naturalUpper(int div) {
        int log10 = (int)Math.log10(div);
        int pow10 = (int)Math.pow(10.0, log10);
        int mul = div / pow10;
        return (mul + 1) * pow10;
    }

    private static int naturalLower(int div) {
        int log10 = (int)Math.log10(div);
        int pow10 = (int)Math.pow(10.0, log10);
        int mul = div / pow10;
        return (mul - 1) * pow10;
    }

    private static Set<Integer> naturalMultiplierSet(TimeUnit unit) {
        int[] nums = TimeStep.naturalMultipliers(unit);
        HashSet<Integer> numSet = new HashSet<Integer>(nums.length);
        for (int num : nums) {
            numSet.add(num);
        }
        return numSet;
    }

    private static int[] naturalMultipliers(TimeUnit unit) {
        switch (unit) {
            case SECONDS: {
                return new int[]{1, 5, 10, 15, 30, 60, 120, 300, 600, 900, 1200};
            }
            case MINUTES: {
                return new int[]{1, 2, 5, 10, 15, 20, 30, 60};
            }
            case HOURS: {
                return new int[]{1, 2, 3, 4, 6, 12, 24};
            }
            case DAYS: {
                return new int[]{1};
            }
        }
        return new int[]{1, 5, 10, 50, 100, 500, 1000};
    }

    private static TimeUnit finerUnit(TimeUnit unit) {
        int ordinal = unit.ordinal();
        if (ordinal == 0) {
            return unit;
        }
        return TimeUnit.values()[ordinal - 1];
    }
}

