/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.method;

import com.azul.jvm.method.MethodSignature;
import java.util.Objects;

public final class MethodFullName {
    private final String klassName;
    private final String methodName;
    private final MethodSignature signature;

    private MethodFullName(String klassName, String methodName, MethodSignature signature) {
        this.klassName = Objects.requireNonNull(klassName, "klassName");
        this.methodName = Objects.requireNonNull(methodName, "methodName");
        this.signature = Objects.requireNonNull(signature, "signature");
    }

    public static MethodFullName of(String klassName, String methodName, MethodSignature signature) {
        return new MethodFullName(klassName, methodName, signature);
    }

    public String klassName() {
        return this.klassName;
    }

    public String methodName() {
        return this.methodName;
    }

    public MethodSignature signature() {
        return this.signature;
    }

    public String toString() {
        return this.klassName + "::" + this.methodName + " " + this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodFullName that = (MethodFullName)o;
        return this.klassName.equals(that.klassName) && this.methodName.equals(that.methodName) && this.signature.equals(that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.klassName, this.methodName, this.signature);
    }
}

