/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.klassloader;

public enum KlassLoaderType {
    UNKNOWN("Unknown", "***not a valid token****"),
    BOOTSTRAP("Boot", "bootstrap"),
    EXT("Ext", "ext"),
    APP("App", "app"),
    OTHER("Other", "other");

    public final String profileId;
    public final String consoleId;

    public static KlassLoaderType fromConsoleLog(String persistentId) {
        for (KlassLoaderType type : KlassLoaderType.values()) {
            if (!type.consoleId.equals(persistentId)) continue;
            return type;
        }
        throw new IllegalArgumentException("invalid console log id: " + persistentId);
    }

    public static KlassLoaderType fromProfileLog(String persistentId) {
        for (KlassLoaderType type : KlassLoaderType.values()) {
            if (!type.profileId.equals(persistentId)) continue;
            return type;
        }
        throw new IllegalArgumentException("invalid profile log id: " + persistentId);
    }

    private KlassLoaderType(String profileId, String persistentId) {
        this.profileId = profileId;
        this.consoleId = persistentId;
    }
}

